/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.PlatStuff;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;

public class MapAtlasCreateRecipe
extends CustomRecipe {
    private final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;
    private WeakReference<Level> levelReference = new WeakReference<Object>(null);

    public MapAtlasCreateRecipe(ResourceLocation id, CraftingBookCategory category, NonNullList<Ingredient> ingredients) {
        super(id, category);
        this.ingredients = ingredients;
        this.isSimple = PlatStuff.isSimple(ingredients);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean matches;
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        boolean hasMap = false;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (MapAtlasesAccessUtils.isValidFilledMap(itemstack)) {
                if (hasMap || MapItem.m_42853_((ItemStack)itemstack, (Level)level) == null) {
                    return false;
                }
                hasMap = true;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        boolean bl = i == this.ingredients.size() && hasMap && (this.isSimple ? stackedcontents.m_36475_((Recipe)this, null) : PlatStuff.findMatches(inputs, this.ingredients)) ? true : (matches = false);
        if (matches) {
            this.levelReference = new WeakReference<Level>(level);
        }
        return matches;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryManager) {
        ItemStack mapItemStack = null;
        for (ItemStack item : inv.m_280657_()) {
            if (!MapAtlasesAccessUtils.isValidFilledMap(item)) continue;
            mapItemStack = item;
            break;
        }
        Level level = (Level)this.levelReference.get();
        if (mapItemStack == null || level == null || mapItemStack.m_41783_() == null) {
            return ItemStack.f_41583_;
        }
        Integer mapId = MapItem.m_151131_((ItemStack)mapItemStack);
        if (mapId == null) {
            MapAtlasesMod.LOGGER.error("MapAtlasCreateRecipe found null Map ID from Filled Map");
            return ItemStack.f_41583_;
        }
        MapDataHolder holder = MapDataHolder.findFromId(level, mapId);
        if (holder == null) {
            return ItemStack.f_41583_;
        }
        ItemStack atlas = new ItemStack((ItemLike)MapAtlasesMod.MAP_ATLAS.get());
        atlas.m_41784_();
        IMapCollection maps = MapAtlasItem.getMaps(atlas, level);
        MapAtlasItem.setSelectedSlice(atlas, holder.slice);
        if (!maps.add(mapId, level)) {
            MapAtlasItem.increaseEmptyMaps(atlas, 1);
        }
        MapAtlasItem.increaseEmptyMaps(atlas, 0);
        return atlas;
    }

    public RecipeSerializer<?> m_7707_() {
        return MapAtlasesMod.MAP_ATLAS_CREATE_RECIPE.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    public static class Serializer
    implements RecipeSerializer<MapAtlasCreateRecipe> {
        public MapAtlasCreateRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buffer) {
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.m_122780_((int)buffer.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            return new MapAtlasCreateRecipe(pRecipeId, craftingbookcategory, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, MapAtlasCreateRecipe pRecipe) {
            pBuffer.m_130068_((Enum)pRecipe.m_245232_());
            pBuffer.m_130130_(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.ingredients) {
                ingredient.m_43923_(pBuffer);
            }
        }

        public MapAtlasCreateRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)pSerializedRecipe, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients"));
            return new MapAtlasCreateRecipe(pRecipeId, craftingbookcategory, nonnulllist);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                nonnulllist.add((Object)Ingredient.m_288218_((JsonElement)pIngredientArray.get(i), (boolean)false));
            }
            return nonnulllist;
        }
    }
}

