/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.BookmarkButton;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;

public class DimensionBookmarkButton
extends BookmarkButton {
    private static final int BUTTON_H = 18;
    private static final int BUTTON_W = 24;
    private final int dimY;
    private final ResourceKey<Level> dimension;

    protected DimensionBookmarkButton(int pX, int pY, ResourceKey<Level> dimension, AtlasOverviewScreen screen) {
        super(pX, pY, 24, 18, 0, 167, screen);
        this.dimension = dimension;
        this.m_257544_(this.createTooltip());
        int i = MapAtlasesClient.DIMENSION_TEXTURE_ORDER.indexOf(dimension.m_135782_().toString());
        if (i == -1) {
            i = 10;
        }
        this.dimY = 16 * i;
    }

    @Override
    public Tooltip createTooltip() {
        return Tooltip.m_257550_((Component)Component.m_237113_((String)AtlasOverviewScreen.getReadableName(this.dimension.m_135782_())));
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack pose = pGuiGraphics.m_280168_();
        pose.m_85836_();
        if (this.selected()) {
            pose.m_252880_(0.0f, 0.0f, 2.0f);
        }
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280218_(MapAtlasesClient.ATLAS_BACKGROUND_TEXTURE, this.m_252754_() + 4, this.m_252907_() + 2, 162, this.dimY, 16, 16);
        pose.m_85849_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setSelected(true);
        this.parentScreen.selectDimension(this.dimension);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.m_5716_(mouseX, mouseY);
    }

    public void m_7435_(SoundManager pHandler) {
        pHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)MapAtlasesMod.ATLAS_PAGE_TURN_SOUND_EVENT.get(), (float)1.0f, (float)((float)MapAtlasesClientConfig.soundScalar.get().doubleValue())));
    }
}

