/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import pepjebs.mapatlases.client.CompoundTooltip;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.BookmarkButton;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.integration.moonlight.CustomDecorationButton;
import pepjebs.mapatlases.networking.C2SRemoveMarkerPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.DecorationHolder;
import pepjebs.mapatlases.utils.MapDataHolder;

public abstract class DecorationBookmarkButton
extends BookmarkButton {
    private static final int BUTTON_H = 14;
    private static final int BUTTON_W = 24;
    protected final MapDataHolder mapData;
    protected final String decorationId;
    protected int index = 0;
    protected boolean shfting = false;
    protected boolean control = false;

    protected DecorationBookmarkButton(int pX, int pY, AtlasOverviewScreen parentScreen, MapDataHolder data, String id) {
        super(pX - 24, pY, 24, 14, 0, 203, parentScreen);
        this.mapData = data;
        this.decorationId = id;
        this.shfting = Screen.m_96638_();
        this.control = Screen.m_96638_();
    }

    public static DecorationBookmarkButton of(int px, int py, DecorationHolder holder, AtlasOverviewScreen screen) {
        Object object = holder.deco();
        if (object instanceof MapDecoration) {
            MapDecoration md = (MapDecoration)object;
            return new Vanilla(px, py, screen, holder.data(), md, holder.id());
        }
        return CustomDecorationButton.create(px, py, screen, holder.data(), holder.deco(), holder.id());
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.shfting = Screen.m_96638_();
        this.control = Screen.m_96637_();
        this.m_257544_(this.createTooltip());
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        this.shfting = Screen.m_96638_();
        this.control = Screen.m_96637_();
        this.m_257544_(this.createTooltip());
        return false;
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setSelected(true);
        if (this.shfting) {
            this.deleteMarker();
            this.parentScreen.recalculateDecorationWidgets();
        } else {
            this.parentScreen.centerOnDecoration(this);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.m_5716_(mouseX, mouseY);
    }

    protected abstract void deleteMarker();

    public abstract double getWorldX();

    public abstract double getWorldZ();

    public abstract Component getDecorationName();

    protected static double getDecorationPos(int decoX, MapItemSavedData data) {
        float s = (float)(1 << data.f_77890_) * 128.0f;
        return (double)s / 2.0 - (double)s / 2.0 * (double)((float)(decoX + 128) / 128.0f);
    }

    public int getBatchGroup() {
        return 0;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack matrices = graphics.m_280168_();
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 0.01 * (double)this.index);
        super.m_87963_(graphics, pMouseX, pMouseY, pPartialTick);
        if (!this.parentScreen.isPlacingPin() && !this.parentScreen.isEditingText()) {
            if (this.control && this.canFocusMarker()) {
                graphics.m_280218_(MapAtlasesClient.ATLAS_BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), 24, 173, 5, 5);
            } else if (this.shfting && this.canDeleteMarker()) {
                graphics.m_280218_(MapAtlasesClient.ATLAS_BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), 24, 167, 5, 5);
            }
        }
        this.renderDecoration(graphics, pMouseX, pMouseY);
        matrices.m_85849_();
        this.setSelected(false);
    }

    protected abstract void renderDecoration(GuiGraphics var1, int var2, int var3);

    @Override
    public Tooltip createTooltip() {
        if (this.control && this.canFocusMarker()) {
            return Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.map_atlases.focus_marker"));
        }
        if (this.shfting && this.canDeleteMarker()) {
            return Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.map_atlases.delete_marker"));
        }
        Component mapIconComponent = this.getDecorationName();
        Tooltip t = Tooltip.m_257550_((Component)mapIconComponent);
        if (!MapAtlasesClientConfig.drawWorldMapCoords.get().booleanValue()) {
            return t;
        }
        MutableComponent coordsComponent = Component.m_237113_((String)("X: " + (int)this.getWorldX() + ", Z: " + (int)this.getWorldZ())).m_130940_(ChatFormatting.GRAY);
        Tooltip t2 = Tooltip.m_257550_((Component)coordsComponent);
        return CompoundTooltip.create(t, t2);
    }

    protected boolean canFocusMarker() {
        return false;
    }

    protected boolean canDeleteMarker() {
        return true;
    }

    public static class Vanilla
    extends DecorationBookmarkButton {
        private final MapDecoration decoration;
        private final boolean isBanner;

        public Vanilla(int px, int py, AtlasOverviewScreen screen, MapDataHolder data, MapDecoration mapDecoration, String decoId) {
            super(px, py, screen, data, decoId);
            this.decoration = mapDecoration;
            this.m_257544_(this.createTooltip());
            this.isBanner = this.decoration.m_77803_().name().startsWith("BANNER");
        }

        @Override
        protected boolean canDeleteMarker() {
            return this.isBanner;
        }

        @Override
        public double getWorldX() {
            return (double)this.mapData.data.f_256718_ - Vanilla.getDecorationPos(this.decoration.m_77804_(), this.mapData.data);
        }

        @Override
        public double getWorldZ() {
            return (double)this.mapData.data.f_256789_ - Vanilla.getDecorationPos(this.decoration.m_77805_(), this.mapData.data);
        }

        @Override
        public Component getDecorationName() {
            Component name = this.decoration.m_77810_();
            return name == null ? Component.m_237113_((String)AtlasOverviewScreen.getReadableName(this.decoration.m_77803_().name().toLowerCase(Locale.ROOT))) : name;
        }

        @Override
        protected void renderDecoration(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
            PoseStack matrices = pGuiGraphics.m_280168_();
            byte b = this.decoration.m_77802_();
            int u = b % 16 * 8;
            int v = b / 16 * 8;
            matrices.m_85837_((double)((float)this.m_252754_() + (float)this.f_93618_ / 2.0f), (double)((float)this.m_252907_() + (float)this.f_93619_ / 2.0f), 0.001);
            matrices.m_252781_(Axis.f_252403_.m_252977_((float)(this.decoration.m_77806_() * 360) / 16.0f));
            matrices.m_85841_(-1.0f, -1.0f, 1.0f);
            pGuiGraphics.m_280163_(MapAtlasesClient.MAP_ICON_TEXTURE, -4, -4, (float)u, (float)v, 8, 8, 128, 128);
        }

        @Override
        protected void deleteMarker() {
            Map decorations = this.mapData.data.f_77894_;
            MapDecoration d = (MapDecoration)decorations.get(this.decorationId);
            if (d != null) {
                MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2SRemoveMarkerPacket(this.mapData.stringId, d.hashCode(), false));
                decorations.remove(this.decorationId);
            }
        }
    }
}

