/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.container;

import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.pavocado.exoticbirds.entity.PigeonEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsMenus;

public class PigeonMenu
extends AbstractContainerMenu {
    public final PigeonEntity pigeon;
    private final Container pigeonContainer;
    private final Container mailContainer = new SimpleContainer(1);
    @Nullable
    public Slot mailSlot;
    private PigeonEntity.RoostStatus roostStatus = PigeonEntity.RoostStatus.NOT_SET;
    @Nullable
    private GlobalPos roostPos;

    public PigeonMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        this(windowId, inventory, PigeonMenu.getPigeonEntity(inventory, buffer));
        this.roostStatus = (PigeonEntity.RoostStatus)buffer.m_130066_(PigeonEntity.RoostStatus.class);
        if (this.roostStatus != PigeonEntity.RoostStatus.NOT_SET) {
            this.roostPos = buffer.m_236872_();
        }
    }

    public PigeonMenu(int windowId, Inventory inventory, PigeonEntity entity) {
        super((MenuType)ExoticBirdsMenus.PIGEON.get(), windowId);
        int column;
        this.pigeonContainer = entity.inventory;
        this.pigeon = entity;
        entity.inventory.m_5856_(inventory.f_35978_);
        if (this.pigeon.hasBackpack()) {
            this.mailSlot = this.m_38897_(new Slot(this.mailContainer, 0, 85, 48){

                public boolean m_6659_() {
                    return PigeonMenu.this.pigeon.hasBackpack();
                }
            });
        }
        this.m_38897_(new Slot(this.pigeonContainer, 0, 8, 18){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42407_);
            }

            public int m_6641_() {
                return 1;
            }
        });
        int playerInventoryStartX = 8;
        int playerInventoryStartY = 84;
        int slotBuffer = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)inventory, 9 + row * 9 + column, playerInventoryStartX + column * slotBuffer, playerInventoryStartY + row * slotBuffer));
            }
        }
        int playerHotbarY = playerInventoryStartY + slotBuffer * 3 + 4;
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)inventory, column, playerInventoryStartX + column * slotBuffer, playerHotbarY));
        }
    }

    private static PigeonEntity getPigeonEntity(Inventory inventory, FriendlyByteBuf buffer) {
        Entity entity = inventory.f_35978_.m_9236_().m_6815_(buffer.readInt());
        if (entity instanceof PigeonEntity) {
            return (PigeonEntity)entity;
        }
        throw new IllegalStateException("Entity is not correct! " + entity);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.pigeonContainer.m_5785_(player);
        if (!player.m_9236_().f_46443_) {
            for (int i = 0; i < this.mailContainer.m_6643_(); ++i) {
                Inventory inventory = player.m_150109_();
                if (!(inventory.f_35978_ instanceof ServerPlayer)) continue;
                inventory.m_150079_(this.mailContainer.m_8016_(i));
            }
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            int i;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int n = i = this.pigeon.hasBackpack() ? 2 : 1;
            if (index < i) {
                if (!this.m_38903_(itemstack1, i, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38853_(1).m_5857_(itemstack1) && !this.m_38853_(1).m_6657_()) {
                if (!this.m_38903_(itemstack1, 1, 2, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38853_(0).m_5857_(itemstack1)) {
                if (!this.m_38903_(itemstack1, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (i <= 1 || !this.m_38903_(itemstack1, 1, i, false)) {
                int j = i + 27;
                int k = j + 9;
                if (index >= j && index < k ? !this.m_38903_(itemstack1, i, j, false) : (index < j ? !this.m_38903_(itemstack1, j, k, false) : !this.m_38903_(itemstack1, j, j, false))) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return !this.pigeon.hasInventoryChanged(this.pigeonContainer) && this.pigeonContainer.m_6542_(player) && this.pigeon.m_6084_() && this.pigeon.m_20270_((Entity)player) < 8.0f && this.pigeon.m_21830_((LivingEntity)player);
    }

    @Nullable
    public GlobalPos getRoostPos() {
        return this.roostPos;
    }

    public PigeonEntity.RoostStatus getRoostStatus() {
        return this.roostStatus;
    }

    public void clearMailSlotItem() {
        if (this.mailSlot != null) {
            this.mailSlot.m_5852_(ItemStack.f_41583_);
        }
    }
}

