/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.entity.GullEntity;

@OnlyIn(value=Dist.CLIENT)
public class GullModel<T extends GullEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation GULL_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "gull"), "main");
    private final ModelPart lowerBeak;
    private final ModelPart topTail;
    private final ModelPart body;
    private final ModelPart breast;
    private final ModelPart bottomTail;
    private final ModelPart upperBeak;
    private final ModelPart rightKnee;
    private final ModelPart rightLeg;
    private final ModelPart leftKnee;
    private final ModelPart rightFoot;
    private final ModelPart leftLeg;
    private final ModelPart leftFoot;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart head;
    private final ModelPart leftWingTip;
    private final ModelPart rightWingTip;

    public GullModel(ModelPart part) {
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.topTail = part.m_171324_("topTail");
        this.body = part.m_171324_("body");
        this.breast = part.m_171324_("breast");
        this.bottomTail = part.m_171324_("bottomTail");
        this.upperBeak = part.m_171324_("upperBeak");
        this.rightKnee = part.m_171324_("rightKnee");
        this.rightLeg = part.m_171324_("rightLeg");
        this.leftKnee = part.m_171324_("leftKnee");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftLeg = part.m_171324_("leftLeg");
        this.leftFoot = part.m_171324_("leftFoot");
        this.leftWing = part.m_171324_("leftWing");
        this.rightWing = part.m_171324_("rightWing");
        this.head = part.m_171324_("head");
        this.leftWingTip = part.m_171324_("leftWingTip");
        this.rightWingTip = part.m_171324_("rightWingTip");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(16, 22).m_171481_(-1.0f, 1.0f, -5.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)11.4f, (float)-4.0f, (float)-1.527421f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("topTail", CubeListBuilder.m_171558_().m_171514_(30, 13).m_171481_(-2.5f, -3.0f, -1.0f, 5.0f, 3.0f, 9.0f), PartPose.m_171423_((float)0.0f, (float)15.5f, (float)2.8f, (float)-0.3717861f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -1.0f, 0.0f, 7.0f, 7.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-2.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-2.0f, (float)-1.30435f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("bottomTail", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 3.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)15.5f, (float)2.8f, (float)0.0743572f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(16, 15).m_171481_(-1.5f, 0.0f, -7.0f, 3.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)11.4f, (float)-4.0f, (float)-1.396263f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightKnee", CubeListBuilder.m_171558_().m_171514_(8, 35).m_171481_(-1.0f, 1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-1.2f, (float)16.8f, (float)1.0f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(4, 39).m_171481_(-0.5f, 1.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.m_171423_((float)-1.2f, (float)17.8f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftKnee", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-1.0f, 1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)1.2f, (float)16.8f, (float)1.0f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171481_(-2.0f, 6.0f, -3.5f, 3.0f, 0.0f, 5.0f), PartPose.m_171423_((float)-1.2f, (float)17.8f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171481_(-0.5f, 1.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.m_171423_((float)1.2f, (float)17.8f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171481_(-1.0f, 6.0f, -3.5f, 3.0f, 0.0f, 5.0f), PartPose.m_171423_((float)1.2f, (float)17.8f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(26, 25).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 6.0f, 9.0f), PartPose.m_171423_((float)3.0f, (float)10.0f, (float)-2.0f, (float)-0.296706f, (float)-0.122173f, (float)-0.2268928f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(26, 40).m_171481_(-1.0f, 0.0f, 0.0f, 1.0f, 6.0f, 9.0f), PartPose.m_171423_((float)-3.0f, (float)10.0f, (float)-2.0f, (float)-0.296706f, (float)0.122173f, (float)0.2268928f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-2.0f, -7.5f, -1.5f, 4.0f, 8.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)11.4f, (float)-4.0f, (float)0.0174533f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftWingTip", CubeListBuilder.m_171558_().m_171514_(46, 25).m_171481_(0.0f, 6.0f, 3.0f, 1.0f, 4.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)10.0f, (float)-2.0f, (float)0.4014257f, (float)-0.122173f, (float)-0.1919862f));
        partdefinition.m_171599_("rightWingTip", CubeListBuilder.m_171558_().m_171514_(46, 36).m_171481_(-1.0f, 6.0f, 3.0f, 1.0f, 4.0f, 7.0f), PartPose.m_171423_((float)-3.0f, (float)10.0f, (float)-2.0f, (float)0.4014257f, (float)0.122173f, (float)0.1919862f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.lowerBeak, (Object)this.upperBeak, (Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.topTail, (Object)this.body, (Object)this.breast, (Object)this.bottomTail, (Object)this.rightKnee, (Object)this.rightLeg, (Object)this.leftKnee, (Object)this.rightFoot, (Object)this.leftLeg, (Object)this.leftFoot, (Object)this.leftWing, (Object)this.rightWing, (Object[])new ModelPart[]{this.leftWingTip, this.rightWingTip});
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((AbstractFlyingBirdEntity)((Object)entityIn)).m_29443_()) {
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftKnee.f_104203_ = -0.0523599f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.rightKnee.f_104203_ = -0.0523599f;
            this.head.f_104203_ = 0.0174533f;
            this.upperBeak.f_104203_ = -1.396263f;
            this.lowerBeak.f_104203_ = -1.527421f;
            this.head.f_104204_ = netHeadYaw / 57.295776f;
            this.leftWing.f_104204_ = -0.122173f;
            this.leftWingTip.f_104204_ = -0.122173f;
            this.rightWing.f_104204_ = 0.122173f;
            this.rightWingTip.f_104204_ = 0.122173f;
        } else {
            this.leftLeg.f_104203_ = 0.9f;
            this.leftFoot.f_104203_ = 0.9f;
            this.leftKnee.f_104203_ = 0.6f;
            this.rightLeg.f_104203_ = 0.9f;
            this.rightFoot.f_104203_ = 0.9f;
            this.rightKnee.f_104203_ = 0.6f;
            this.head.f_104203_ = 0.8174533f;
            this.upperBeak.f_104203_ = -0.596263f;
            this.lowerBeak.f_104203_ = -0.727421f;
            this.head.f_104204_ = 0.0174533f;
            this.leftWing.f_104204_ = 0.4f;
            this.leftWingTip.f_104204_ = 0.4f;
            this.rightWing.f_104204_ = -0.4f;
            this.rightWingTip.f_104204_ = -0.4f;
        }
        this.rightWing.f_104205_ = ageInTicks + 0.2268928f;
        this.leftWing.f_104205_ = -(ageInTicks + 0.2268928f);
        this.rightWingTip.f_104205_ = ageInTicks + 0.1919862f;
        this.leftWingTip.f_104205_ = -(ageInTicks + 0.1919862f);
        this.lowerBeak.f_104204_ = this.head.f_104204_;
        this.upperBeak.f_104204_ = this.head.f_104204_;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.45f, 0.45f, 0.45f);
            stack.m_252880_(0.0f, 1.8f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            stack.m_252880_(0.0f, 0.65f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

