/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.propellant;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonMunitionBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.PrimedPropellant;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.config.PowderChargeProperties;

public class PowderChargeBlock
extends RotatedPillarBlock
implements IWrenchable,
BigCannonPropellantBlock,
SimpleWaterloggedBlock {
    private static final EnumProperty<Direction.Axis> AXIS = RotatedPillarBlock.f_55923_;
    private final VoxelShaper shapes;

    public PowderChargeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DAMP, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    private VoxelShaper makeShapes() {
        VoxelShape base = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        return new AllShapes.Builder(base).forAxis();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
        builder.m_61104_(new Property[]{DAMP});
    }

    public boolean m_6724_(BlockState state) {
        return BigCannonMunitionBlock.canDry(state);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        boolean result = super.m_7361_(level, pos, state, fluidState);
        if (result && !level.m_5776_()) {
            level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)DAMP, (Comparable)Boolean.valueOf(true)), 3);
        }
        return result;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (BigCannonMunitionBlock.canDry(state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)DAMP, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack itemStack = context.m_43722_();
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        boolean damp = (itemStack.m_41784_().m_128471_("Damp") || waterlogged) && !context.m_43725_().m_6042_().f_63857_();
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)DAMP, (Comparable)Boolean.valueOf(damp))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return this.shapes.get((Direction.Axis)state.m_61143_(AXIS));
    }

    @Override
    public boolean canBeLoaded(BlockState state, Direction.Axis axis) {
        return axis == state.m_61143_(AXIS);
    }

    @Override
    public boolean canBeIgnited(StructureTemplate.StructureBlockInfo data, Direction dir) {
        return (Boolean)data.f_74676_().m_61143_((Property)DAMP) == false || (Boolean)CBCConfigs.server().munitions.dampPropellantBlocksStartingIgnition.get() == false || !this.getProperties().propellantProperties().dampAmmoDoesntIgniteAsStarter();
    }

    public float getPowerMultiplier(StructureTemplate.StructureBlockInfo data) {
        return (Boolean)CBCConfigs.server().munitions.dampPropellantWeakensPropellant.get() != false && (Boolean)data.f_74676_().m_61143_((Property)DAMP) != false ? this.getProperties().propellantProperties().dampAmmoStrengthDebuff() : 1.0f;
    }

    public float getPowerMultiplier(ItemStack stack) {
        return (Boolean)CBCConfigs.server().munitions.dampPropellantWeakensPropellant.get() != false && stack.m_41784_().m_128471_("Damp") ? this.getProperties().propellantProperties().dampAmmoStrengthDebuff() : 1.0f;
    }

    @Override
    public float getChargePower(StructureTemplate.StructureBlockInfo data) {
        return this.getPowerMultiplier(data) * this.getProperties().propellantProperties().strength();
    }

    @Override
    public float getChargePower(ItemStack stack) {
        return this.getPowerMultiplier(stack) * this.getProperties().propellantProperties().strength();
    }

    @Override
    public float getStressOnCannon(StructureTemplate.StructureBlockInfo data) {
        return this.getPowerMultiplier(data) * this.getProperties().propellantProperties().addedStress();
    }

    @Override
    public float getStressOnCannon(ItemStack stack) {
        return this.getPowerMultiplier(stack) * this.getProperties().propellantProperties().addedStress();
    }

    @Override
    public float getSpread(StructureTemplate.StructureBlockInfo data) {
        return this.getPowerMultiplier(data) * this.getProperties().propellantProperties().addedSpread();
    }

    @Override
    public float getRecoil(StructureTemplate.StructureBlockInfo data) {
        return this.getPowerMultiplier(data) * this.getProperties().propellantProperties().addedRecoil();
    }

    @Override
    public void consumePropellant(BigCannonBehavior behavior) {
        behavior.removeBlock();
    }

    @Override
    public BlockState onCannonRotate(BlockState oldState, Direction.Axis rotationAxis, Rotation rotation) {
        if (oldState.m_61138_((Property)BlockStateProperties.f_61365_)) {
            Direction.Axis axis = (Direction.Axis)oldState.m_61143_((Property)BlockStateProperties.f_61365_);
            if (axis == rotationAxis) {
                return oldState;
            }
            for (int i = 0; i < rotation.ordinal(); ++i) {
                axis = switch (axis) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X -> {
                        if (rotationAxis == Direction.Axis.Y) {
                            yield Direction.Axis.Z;
                        }
                        yield Direction.Axis.Y;
                    }
                    case Direction.Axis.Y -> {
                        if (rotationAxis == Direction.Axis.X) {
                            yield Direction.Axis.Z;
                        }
                        yield Direction.Axis.X;
                    }
                    case Direction.Axis.Z -> rotationAxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y;
                };
            }
            return (BlockState)oldState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
        }
        return oldState;
    }

    @Override
    public Direction.Axis getAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_(AXIS);
    }

    @Override
    public StructureTemplate.StructureBlockInfo getHandloadingInfo(ItemStack stack, BlockPos localPos, Direction cannonOrientation) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)cannonOrientation.m_122434_())).m_61124_((Property)DAMP, (Comparable)Boolean.valueOf(stack.m_41784_().m_128471_("Damp")));
        return new StructureTemplate.StructureBlockInfo(localPos, state, null);
    }

    @Override
    public ItemStack getExtractedItem(StructureTemplate.StructureBlockInfo info) {
        ItemStack result = new ItemStack((ItemLike)this);
        if (((Boolean)info.f_74676_().m_61143_((Property)DAMP)).booleanValue()) {
            result.m_41784_().m_128379_("Damp", true);
        }
        return result;
    }

    protected PowderChargeProperties getProperties() {
        return (PowderChargeProperties)CBCMunitionPropertiesHandlers.POWDER_CHARGE.getPropertiesOf(this);
    }

    @Override
    public void createbigcannons$onBlockExplode(Level level, BlockPos pos, BlockState state, Explosion explosion) {
        if (!level.f_46443_ && !BigCannonMunitionBlock.doesntIgnite(state)) {
            this.spawnPrimedPropellant(level, pos, state);
        }
    }

    public PrimedPropellant spawnPrimedPropellant(Level level, BlockPos pos, BlockState state) {
        Vec3 entityPos = Vec3.m_82512_((Vec3i)pos);
        PrimedPropellant propellant = PrimedPropellant.create(level, entityPos.m_7096_(), entityPos.m_7098_(), entityPos.m_7094_(), state);
        propellant.setExplosionPower(this.getProperties().propellantProperties().explosionPower());
        level.m_7967_((Entity)propellant);
        return propellant;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!PowderChargeBlock.isPropellantIgniter(itemStack, player) || BigCannonMunitionBlock.doesntIgnite(state)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        PrimedPropellant propellant = this.spawnPrimedPropellant(level, pos, state);
        propellant.setFuse(10);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        Item item = itemStack.m_41720_();
        if (!player.m_7500_()) {
            if (itemStack.m_150930_(Items.f_42409_)) {
                itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            } else {
                itemStack.m_41774_(1);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (level.f_46443_) {
            return;
        }
        BlockPos blockPos = hit.m_82425_();
        if (!projectile.m_6060_() || !projectile.m_142265_(level, blockPos) || BigCannonMunitionBlock.doesntIgnite(state)) {
            return;
        }
        this.spawnPrimedPropellant(level, blockPos, state);
        level.m_7471_(blockPos, false);
    }

    public static boolean isPropellantIgniter(ItemStack itemStack, Player player) {
        return itemStack.m_150930_(Items.f_42409_) || itemStack.m_150930_(Items.f_42613_);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack result = super.m_7397_(level, pos, state);
        if (((Boolean)state.m_61143_((Property)DAMP)).booleanValue()) {
            result.m_41784_().m_128379_("Damp", true);
        }
        return result;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)DAMP)).booleanValue() && random.m_188503_(5) < 2) {
            Direction.Axis axis = this.getAxis(state);
            for (int i = 0; i < random.m_188503_(1) + 1; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, (double)pos.m_123341_() + (axis == Direction.Axis.X ? (double)random.m_188501_() : 0.5 + (double)((float)(random.m_188499_() ? -1 : 1) * random.m_188501_() * 0.42f)), (double)pos.m_123342_() + (axis == Direction.Axis.Y ? (double)random.m_188501_() : 0.5 + (double)((float)(random.m_188499_() ? -1 : 1) * random.m_188501_() * 0.42f)), (double)pos.m_123343_() + (axis == Direction.Axis.Z ? (double)random.m_188501_() : 0.5 + (double)((float)(random.m_188499_() ? -1 : 1) * random.m_188501_() * 0.42f)), (double)(random.m_188501_() * 0.02f), 5.0E-5, (double)(random.m_188501_() * 0.02f));
            }
        }
    }
}

