/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech;

import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class QuickfiringBreechVisual
extends AbstractBlockEntityVisual<QuickfiringBreechBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance breechblock;
    private final OrientedInstance shaft;
    private final OrientedInstance lever;
    private final Direction direction;
    private final Direction blockRotation;

    public QuickfiringBreechVisual(VisualizationContext ctx, QuickfiringBreechBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        Direction.Axis axis = QuickfiringBreechVisual.getRotationAxis(this.blockState);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction blockRotation = facing.m_175364_(axis);
        this.direction = facing.m_175364_(blockRotation.m_122434_());
        if (blockRotation == Direction.DOWN) {
            blockRotation = Direction.UP;
        }
        this.blockRotation = blockRotation;
        this.breechblock = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)QuickfiringBreechVisual.getPartialModelForState(this.blockState))).createInstance();
        this.shaft = ((OrientedInstance)((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance()).rotateTo(Direction.UP, this.direction)).position((Vec3i)this.getVisualPosition());
        this.lever = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)CBCBlockPartials.QUICKFIRING_BREECH_LEVER, (Direction)this.direction)).createInstance();
        boolean alongFirst = (Boolean)this.blockState.m_61143_((Property)QuickfiringBreechBlock.AXIS);
        if (!alongFirst) {
            this.breechblock.rotateYDegrees(90.0f);
        }
        if (facing.m_122434_().m_122479_()) {
            this.breechblock.rotateTo(Direction.NORTH, Direction.UP);
        }
        this.transformModels(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    private void transformModels(float partialTick) {
        float progress = ((QuickfiringBreechBlockEntity)this.blockEntity).getOpenProgress(partialTick);
        BlockPos visualPos = this.getVisualPosition();
        float renderedBreechblockOffset = progress / 16.0f * 13.0f;
        Vector3f normal = this.blockRotation.m_253071_();
        normal.mul(renderedBreechblockOffset);
        this.breechblock.position((Vec3i)visualPos).translatePosition(normal.x(), normal.y(), normal.z()).setChanged();
        float angle = progress * 90.0f;
        Quaternionf qrot = Axis.m_253057_((Vector3f)this.direction.m_253071_()).m_252977_(angle);
        ((OrientedInstance)this.shaft.position((Vec3i)visualPos).identityRotation().rotate((Quaternionfc)qrot).rotateTo(Direction.UP, this.direction)).setChanged();
        this.lever.position((Vec3i)visualPos.m_121945_(this.direction)).rotation((Quaternionfc)qrot).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.breechblock});
        this.relight(this.pos, new FlatLit[]{this.shaft});
        this.relight(this.pos, new FlatLit[]{this.lever});
    }

    public void _delete() {
        this.breechblock.delete();
        this.shaft.delete();
        this.lever.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.breechblock);
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.lever);
    }

    private static PartialModel getPartialModelForState(BlockState state) {
        PartialModel partialModel;
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            partialModel = CBCBlockPartials.breechblockFor(cBlock.getCannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_SLIDING_BREECHBLOCK;
        }
        return partialModel;
    }

    private static Direction.Axis getRotationAxis(BlockState state) {
        boolean flag = (Boolean)state.m_61143_((Property)QuickfiringBreechBlock.AXIS);
        return switch (((Direction)state.m_61143_((Property)QuickfiringBreechBlock.f_52588_)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (flag) {
                    yield Direction.Axis.Y;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Y -> {
                if (flag) {
                    yield Direction.Axis.X;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Z -> flag ? Direction.Axis.X : Direction.Axis.Y;
        };
    }
}

