/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.simibubi.create.foundation.utility.BlockHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.base.PropertySetter;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class BlockTransformation {
    private static final Transform NO_TRANSFORM = new Transform(){

        @Override
        public BlockState apply(BlockState blockState) {
            return blockState;
        }
    };
    private final Map<Transform, Float> weightedTransforms;
    private final float weightSum;
    private final float chance;

    public BlockTransformation(Map<Transform, Float> weightedTransforms, float chance) {
        this.weightedTransforms = weightedTransforms;
        float sum = 0.0f;
        for (Float f : this.weightedTransforms.values()) {
            sum += f.floatValue();
        }
        this.weightSum = sum;
        this.chance = chance;
    }

    public BlockState transformBlock(BlockState inputBlockState) {
        if (Math.random() > (double)this.chance) {
            return inputBlockState;
        }
        float sum = this.weightSum;
        Transform transform = NO_TRANSFORM;
        for (Map.Entry<Transform, Float> entry : this.weightedTransforms.entrySet()) {
            float weight = entry.getValue().floatValue();
            if (Math.random() * (double)sum <= (double)weight) {
                transform = entry.getKey();
                break;
            }
            sum -= weight;
        }
        return (BlockState)transform.apply(inputBlockState);
    }

    public static BlockTransformation fromJson(JsonObject obj) throws JsonParseException {
        JsonArray array = GsonHelper.m_13933_((JsonObject)obj, (String)"transforms");
        Object2ObjectLinkedOpenHashMap weightedTransforms = new Object2ObjectLinkedOpenHashMap();
        for (JsonElement el : array) {
            JsonObject transformObj = el.getAsJsonObject();
            Transform transform = Transform.optionalFromJson(GsonHelper.m_13930_((JsonObject)transformObj, (String)"transform"));
            float weight = GsonHelper.m_13820_((JsonObject)transformObj, (String)"weight", (float)1.0f);
            weightedTransforms.put(transform, Float.valueOf(weight));
        }
        float chance = Mth.m_14036_((float)GsonHelper.m_13820_((JsonObject)obj, (String)"transform_chance", (float)1.0f), (float)0.0f, (float)1.0f);
        return new BlockTransformation((Map<Transform, Float>)weightedTransforms, chance);
    }

    public static interface Transform
    extends UnaryOperator<BlockState> {
        private static Transform optionalFromJson(JsonObject obj) throws JsonParseException {
            String id = GsonHelper.m_13906_((JsonObject)obj, (String)"block");
            ResourceLocation blockLocation = CBCUtils.location(id);
            Optional<Block> optional = CBCRegistryUtils.getOptionalBlock(blockLocation);
            if (optional.isEmpty()) {
                return NO_TRANSFORM;
            }
            Block block = optional.get();
            boolean copy = GsonHelper.m_13855_((JsonObject)obj, (String)"copy_properties", (boolean)false);
            ArrayList propertySetters = new ArrayList();
            JsonArray arr = GsonHelper.m_13832_((JsonObject)obj, (String)"properties", (JsonArray)new JsonArray());
            StateDefinition definition = block.m_49965_();
            for (JsonElement el : arr) {
                JsonObject setterObj = el.getAsJsonObject();
                String propertyName = GsonHelper.m_13906_((JsonObject)setterObj, (String)"property");
                Property property = definition.m_61081_(propertyName);
                if (property == null) {
                    throw new JsonParseException("Block " + String.valueOf(blockLocation) + " does not have property \"" + propertyName + "\"");
                }
                String value = GsonHelper.m_13906_((JsonObject)setterObj, (String)"value");
                PropertySetter setter = Transform.getSetterHelper(property, value);
                propertySetters.add(setter);
            }
            return new Impl(block, propertySetters, copy);
        }

        private static <T extends Comparable<T>> PropertySetter<T> getSetterHelper(Property<T> property, String value) {
            Optional optional = property.m_6215_(value);
            if (optional.isEmpty()) {
                throw new JsonParseException("Unable to read property: %s with value: %s".formatted(property, value));
            }
            return PropertySetter.of(property, (Comparable)optional.get());
        }

        public record Impl(Block base, List<PropertySetter<?>> propertySetters, boolean copyProperties) implements Transform
        {
            @Override
            public BlockState apply(BlockState inputBlockState) {
                BlockState outputState = this.base.m_49966_();
                if (this.copyProperties) {
                    outputState = BlockHelper.copyProperties((BlockState)inputBlockState, (BlockState)outputState);
                }
                for (PropertySetter<?> setter : this.propertySetters) {
                    outputState = setter.applyTo(outputState);
                }
                return outputState;
            }
        }
    }
}

