/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.core.data.loot;

import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.github.teamfusion.rottencreatures.core.mixin.access.BuiltInLootTablesAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public record LootBuilder(String key) {
    public static LootBuilder of(String key) {
        return new LootBuilder(key);
    }

    public ResourceLocation build(String type) {
        return BuiltInLootTablesAccessor.callRegister(RottenCreatures.resource("entities/" + this.key() + "/" + type));
    }

    public ResourceLocation build() {
        return BuiltInLootTablesAccessor.callRegister(RottenCreatures.resource("entities/" + this.key()));
    }

    public static LootPool.Builder rolls(int rolls) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)rolls));
    }

    public static LootPool.Builder rolls(int min, int max) {
        return LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
    }

    public static LootPoolSingletonContainer.Builder<?> entry(ItemLike entry) {
        return LootItem.m_79579_((ItemLike)entry);
    }

    public static LootItemFunction.Builder count(int count) {
        return LootBuilder.count(count, count);
    }

    public static LootItemFunction.Builder count(int min, int max) {
        return SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
    }

    public static LootItemFunction.Builder looting(int min, int max) {
        return LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
    }

    public static LootItemCondition.Builder chance(float chance) {
        return LootItemRandomChanceCondition.m_81927_((float)chance);
    }

    public static LootItemCondition.Builder chanceWithLooting(float chance, float loot) {
        return LootItemRandomChanceWithLootingCondition.m_81963_((float)chance, (float)loot);
    }

    public static LootItemCondition.Builder killedByPlayer() {
        return LootItemKilledByPlayerCondition.m_81901_();
    }
}

