/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.glacialhunter;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.living.glacialhunter.HunterWolf;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.common.registries.RCItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GlacialHunter
extends Zombie {
    public GlacialHunter(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 6;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    protected void m_6878_() {
        super.m_6878_();
        this.f_21346_.m_25352_(1, (Goal)new ZombieAttackGoal(this, 1.0, false){

            protected double m_6639_(LivingEntity living) {
                double reach = this.f_25540_.m_20205_() * 3.0f * this.f_25540_.m_20205_() * 3.0f + living.m_20205_();
                return GlacialHunter.this.hasSpear() ? reach : super.m_6639_(living);
            }
        });
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.hasSpear()) {
            this.m_21051_(Attributes.f_22281_).m_22100_(6.0);
            this.m_21051_(Attributes.f_22282_).m_22100_(1.5);
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        if (this.m_9236_().m_213780_().m_188501_() <= 0.4f) {
            this.setSpear();
        }
    }

    public boolean hasSpear() {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(RCItems.SPEAR.get());
    }

    private void setSpear() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)RCItems.SPEAR.get()));
    }

    protected float m_21519_(EquipmentSlot slot) {
        return this.m_6844_(slot).m_150930_(RCItems.SPEAR.get()) ? 0.0f : super.m_21519_(slot);
    }

    public boolean m_7327_(Entity entity) {
        boolean hurtTarget = super.m_7327_(entity);
        if (hurtTarget && this.m_21205_().m_41619_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            living.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 140 * (int)modifier), (Entity)this);
        }
        return hurtTarget;
    }

    protected ItemStack m_5728_() {
        return new ItemStack((ItemLike)RCBlocks.GLACIAL_HUNTER_HEAD.get());
    }

    protected boolean m_5884_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean baby) {
    }

    public void m_7023_(Vec3 vec3) {
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.hasSpear() ? 1.5f : 1.0f));
        super.m_7023_(vec3);
    }

    public static boolean checkGlacialHunterSpawnRules(EntityType<GlacialHunter> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return GlacialHunter.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        HunterWolf wolf = (HunterWolf)RCEntityTypes.HUNTER_WOLF.get().m_20615_(this.m_9236_());
        if (level.m_213780_().m_188501_() <= 0.3f && spawnType == MobSpawnType.NATURAL && wolf != null) {
            wolf.m_20035_(this.m_20183_().m_7918_(-2 + this.m_9236_().f_46441_.m_188503_(3), 1, -2 + this.m_9236_().f_46441_.m_188503_(3)), 0.0f, 0.0f);
            wolf.setOwner((LivingEntity)this);
            level.m_7967_((Entity)wolf);
        }
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    protected SoundEvent m_7515_() {
        return RCSoundEvents.GLACIAL_HUNTER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RCSoundEvents.GLACIAL_HUNTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return RCSoundEvents.GLACIAL_HUNTER_DEATH.get();
    }
}

