/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.burned;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.living.frostbitten.Frostbitten;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.core.data.loot.RCLootTables;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Burned
extends Zombie {
    private static final AttributeModifier CRAZY_MODIFIER = new AttributeModifier(UUID.fromString("a0ffa7a6-1210-466a-a9a1-31909417a99e"), "Crazy attribute boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier OBSIDIAN_MODIFIER = new AttributeModifier(UUID.fromString("cf2ce4af-4807-4896-aaad-1c077a87e9bf"), "Obsidian attribute boost", 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> DATA_IS_OBSIDIAN = SynchedEntityData.m_135353_(Burned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CRAZY = SynchedEntityData.m_135353_(Burned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Burned(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
    }

    protected void m_6878_() {
        super.m_6878_();
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Frostbitten.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_IS_OBSIDIAN, (Object)false);
        this.m_20088_().m_135372_(DATA_IS_CRAZY, (Object)false);
    }

    protected ResourceLocation m_7582_() {
        return this.isObsidian() ? RCLootTables.BURNED_OBSIDIAN : super.m_7582_();
    }

    protected boolean m_7593_() {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if ((double)this.m_21223_() <= (double)this.m_21233_() * 0.5 && !this.isCrazy()) {
            this.setCrazy(true);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)(this.isObsidian() ? ParticleTypes.f_123787_ : ParticleTypes.f_123801_), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.isCrazy() && this.f_19796_.m_188503_(10) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)(this.isObsidian() ? (this.f_19796_.m_188499_() ? ParticleTypes.f_123762_ : ParticleTypes.f_123755_) : ParticleTypes.f_123756_), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            if (this.m_20072_() && !this.isObsidian()) {
                this.setObsidian(true);
            }
            if (this.m_20077_() && this.isObsidian()) {
                this.setObsidian(false);
            }
        }
        super.m_8119_();
    }

    protected SoundEvent m_7515_() {
        return RCSoundEvents.BURNED_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RCSoundEvents.BURNED_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return RCSoundEvents.BURNED_DEATH.get();
    }

    public boolean m_7327_(Entity entity) {
        boolean hurt = super.m_7327_(entity);
        if (hurt && this.m_21205_().m_41619_() && !this.isObsidian() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            living.m_20254_(3 * (int)modifier);
        }
        return hurt;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isObsidian() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6126_() {
        return !this.isObsidian() && !this.m_20072_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsObsidian", this.isObsidian());
        tag.m_128379_("IsCrazy", this.isCrazy());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setObsidian(tag.m_128471_("IsObsidian"));
        this.setCrazy(tag.m_128471_("IsCrazy"));
    }

    public boolean isObsidian() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IS_OBSIDIAN);
    }

    public void setObsidian(boolean obsidian) {
        this.m_20088_().m_135381_(DATA_IS_OBSIDIAN, (Object)obsidian);
        if (!this.m_9236_().f_46443_) {
            AttributeInstance attackDamage = this.m_21051_(Attributes.f_22281_);
            AttributeInstance knockbackResistance = this.m_21051_(Attributes.f_22278_);
            if (attackDamage != null && knockbackResistance != null) {
                attackDamage.m_22130_(OBSIDIAN_MODIFIER);
                knockbackResistance.m_22130_(OBSIDIAN_MODIFIER);
                if (obsidian) {
                    attackDamage.m_22118_(OBSIDIAN_MODIFIER);
                    knockbackResistance.m_22118_(OBSIDIAN_MODIFIER);
                }
            }
        }
        if (obsidian) {
            this.m_9236_().m_46796_(1501, this.m_20183_(), 0);
        }
    }

    public boolean isCrazy() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IS_CRAZY);
    }

    public void setCrazy(boolean crazy) {
        this.m_20088_().m_135381_(DATA_IS_CRAZY, (Object)crazy);
        if (!this.m_9236_().f_46443_) {
            AttributeInstance attackDamage = this.m_21051_(Attributes.f_22281_);
            AttributeInstance knockbackResistance = this.m_21051_(Attributes.f_22278_);
            if (attackDamage != null && knockbackResistance != null) {
                attackDamage.m_22130_(CRAZY_MODIFIER);
                knockbackResistance.m_22130_(CRAZY_MODIFIER);
                if (crazy) {
                    attackDamage.m_22118_(CRAZY_MODIFIER);
                    knockbackResistance.m_22118_(CRAZY_MODIFIER);
                }
            }
        }
    }

    public void m_7023_(Vec3 vector) {
        this.m_7910_(this.getMoveSpeed());
        super.m_7023_(vector);
    }

    public float getMoveSpeed() {
        return (float)this.m_21133_(Attributes.f_22279_) * (this.isObsidian() ? 0.5f : (this.isCrazy() ? 1.5f : 1.0f));
    }

    protected ItemStack m_5728_() {
        return new ItemStack((ItemLike)RCBlocks.BURNED_HEAD.get());
    }

    protected int m_5639_(float distance, float amount) {
        return super.m_5639_(distance, amount) - (this.isObsidian() ? 10 : 0);
    }

    public static boolean checkBurnedSpawnRules(EntityType<Burned> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50451_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        if (this.f_19796_.m_188501_() <= 0.05f) {
            this.setCrazy(true);
        }
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }
}

