/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blockentities;

import com.github.teamfusion.rottencreatures.common.registries.RCBlockEntityTypes;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TreasureChestBlockEntity
extends BlockEntity {
    private static final int MAX_ITEMS = 64;
    private final NonNullList<ItemStack> items = NonNullList.m_122779_();
    private int totalCount = 0;
    private UUID ownerUUID;
    public int maxStackSize = 64;

    public TreasureChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(RCBlockEntityTypes.TREASURE_CHEST.get(), blockPos, blockState);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag itemsList = new ListTag();
        for (ItemStack stack : this.items) {
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            itemsList.add((Object)itemTag);
        }
        tag.m_128365_("Items", (Tag)itemsList);
        tag.m_128405_("ItemCount", this.totalCount);
        tag.m_128405_("MaxStackSize", this.maxStackSize);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_142466_(CompoundTag tag) {
        ItemStack stack;
        super.m_142466_(tag);
        this.items.clear();
        this.totalCount = 0;
        if (tag.m_128425_("Items", 9)) {
            ListTag itemsList = tag.m_128437_("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTag = itemsList.m_128728_(i);
                ItemStack stack2 = ItemStack.m_41712_((CompoundTag)itemTag);
                if (stack2.m_41619_()) continue;
                this.items.add((Object)stack2);
                this.totalCount += stack2.m_41613_();
            }
        } else if (tag.m_128425_("Item", 10) && !(stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"))).m_41619_()) {
            this.items.add((Object)stack);
            this.totalCount = stack.m_41613_();
        }
        this.maxStackSize = tag.m_128441_("MaxStackSize") ? tag.m_128451_("MaxStackSize") : (!this.items.isEmpty() ? Math.min(((ItemStack)this.items.get(0)).m_41741_(), 64) : 64);
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean hasContents() {
        return !this.items.isEmpty() && this.totalCount != 0;
    }

    public NonNullList<ItemStack> addItemsWithReplacement(ItemStack stack, int count) {
        if (stack.m_41619_() || count <= 0) {
            return NonNullList.m_122779_();
        }
        NonNullList replacedItems = NonNullList.m_122779_();
        int itemMaxStackSize = stack.m_41741_();
        if (this.items.isEmpty()) {
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            return replacedItems;
        }
        if (((ItemStack)this.items.get(0)).m_41741_() != itemMaxStackSize) {
            replacedItems.addAll(this.removeAllItems());
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            return replacedItems;
        }
        int spaceLeft = this.maxStackSize - this.totalCount;
        int toAdd = Math.min(count, this.maxStackSize);
        if (spaceLeft >= toAdd) {
            for (int i = 0; i < this.items.size() && toAdd > 0; ++i) {
                int canAdd;
                ItemStack existingStack = (ItemStack)this.items.get(i);
                if (!ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)stack) || (canAdd = Math.min(toAdd, existingStack.m_41741_() - existingStack.m_41613_())) <= 0) continue;
                existingStack.m_41769_(canAdd);
                toAdd -= canAdd;
                this.totalCount += canAdd;
                this.m_6596_();
            }
            if (toAdd > 0) {
                this.addItem(stack, toAdd);
            }
        } else {
            int itemsReplaced = 0;
            int remainingToAdd = toAdd;
            for (int i = 0; i < this.items.size() && itemsReplaced < toAdd && remainingToAdd > 0; ++i) {
                ItemStack oldStack = (ItemStack)this.items.get(i);
                if (ItemStack.m_150942_((ItemStack)oldStack, (ItemStack)stack)) continue;
                int toRemove = Math.min(oldStack.m_41613_(), remainingToAdd);
                if (toRemove == oldStack.m_41613_()) {
                    replacedStack = oldStack.m_41777_();
                    this.items.remove(i);
                    --i;
                    replacedItems.add((Object)replacedStack);
                    this.totalCount -= toRemove;
                } else {
                    replacedStack = oldStack.m_41777_();
                    replacedStack.m_41764_(toRemove);
                    replacedItems.add((Object)replacedStack);
                    oldStack.m_41774_(toRemove);
                    this.totalCount -= toRemove;
                }
                itemsReplaced += toRemove;
                remainingToAdd -= toRemove;
            }
            if (remainingToAdd > 0) {
                while (this.totalCount + remainingToAdd > this.maxStackSize && !this.items.isEmpty()) {
                    ItemStack oldStack = (ItemStack)this.items.get(0);
                    int toRemove = Math.min(oldStack.m_41613_(), this.totalCount + remainingToAdd - this.maxStackSize);
                    if (toRemove == oldStack.m_41613_()) {
                        this.items.remove(0);
                        replacedItems.add((Object)oldStack);
                        this.totalCount -= toRemove;
                    } else {
                        ItemStack replacedStack = oldStack.m_41777_();
                        replacedStack.m_41764_(toRemove);
                        replacedItems.add((Object)replacedStack);
                        oldStack.m_41774_(toRemove);
                        this.totalCount -= toRemove;
                    }
                    itemsReplaced += toRemove;
                    remainingToAdd -= toRemove;
                }
            }
            remainingToAdd = toAdd;
            for (int i = 0; i < this.items.size() && remainingToAdd > 0; ++i) {
                int canAdd;
                ItemStack existingStack = (ItemStack)this.items.get(i);
                if (!ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)stack) || (canAdd = Math.min(remainingToAdd, existingStack.m_41741_() - existingStack.m_41613_())) <= 0) continue;
                existingStack.m_41769_(canAdd);
                remainingToAdd -= canAdd;
                this.totalCount += canAdd;
                this.m_6596_();
            }
            if (remainingToAdd > 0) {
                this.addItem(stack, remainingToAdd);
            }
        }
        this.items.removeIf(ItemStack::m_41619_);
        return replacedItems;
    }

    private void addItem(ItemStack stack, int count) {
        int stackSize;
        int itemMaxStackSize = stack.m_41741_();
        for (int toAdd = count; toAdd > 0; toAdd -= stackSize) {
            ItemStack newStack = stack.m_41777_();
            stackSize = Math.min(toAdd, itemMaxStackSize);
            newStack.m_41764_(stackSize);
            this.items.add((Object)newStack);
            this.totalCount += stackSize;
        }
        this.m_6596_();
    }

    public NonNullList<ItemStack> removeAllItems() {
        NonNullList result = NonNullList.m_122779_();
        result.addAll(this.items);
        this.items.clear();
        this.totalCount = 0;
        this.maxStackSize = 64;
        this.m_6596_();
        return result;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
        this.m_6596_();
    }

    public boolean isOwner(UUID playerUUID) {
        return this.ownerUUID != null && this.ownerUUID.equals(playerUUID);
    }
}

