/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client;

import com.blackgear.platform.client.GameRendering;
import com.blackgear.platform.core.ParallelDispatch;
import com.github.teamfusion.rottencreatures.client.VanillaCreativeTabIntegration;
import com.github.teamfusion.rottencreatures.client.registries.RCModelLayers;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.BurnedSkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.DeadBeardSkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.FrostbittenSkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.GlacialHunterSkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.ImmortalSkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.MummySkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.SwampySkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.TreasureChestBlockModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.UndeadMinerSkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.blockentities.ZapSkullModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.BurnedModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.DeadBeardModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.FrostbittenModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.GlacialHunterModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.ImmortalModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.ImmortalOverlayModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.MummyModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.ScarabModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.SwampyModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.UndeadMinerModel;
import com.github.teamfusion.rottencreatures.client.rendering.model.entities.ZapModel;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.blockentities.TreasureChestBlockRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.TntBarrelRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.burned.BurnedRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.deadbeard.DeadBeardRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.frostbitten.FrostbittenRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.glacialhunter.GlacialHunterRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.glacialhunter.HunterWolfRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.immortal.DashAttackLayer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.immortal.ImmortalRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.lackey.SkeletonLackeyRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.lackey.ZombieLackeyRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.mummy.MummyRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.scarab.ScarabRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.swampy.SwampyRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.undeadminer.UndeadMinerRenderer;
import com.github.teamfusion.rottencreatures.client.rendering.renderer.entities.zap.ZapRenderer;
import com.github.teamfusion.rottencreatures.common.level.blocks.SkullTypes;
import com.github.teamfusion.rottencreatures.common.registries.RCBlockEntityTypes;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.common.registries.RCItems;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;

public class ClientSetup {
    public static final ModelResourceLocation SPEAR_HANDHELD_MODEL = new ModelResourceLocation(RottenCreatures.resource("spear_in_hand"), "inventory");

    public static void setup() {
        GameRendering.registerModelLayers(ClientSetup::modelLayerRegistry);
        GameRendering.registerEntityRenderers(ClientSetup::entityRendererRegistry);
        GameRendering.registerBlockEntityRenderers(ClientSetup::blockEntityRendererRegistry);
    }

    public static void asyncSetup(ParallelDispatch dispatch) {
        GameRendering.registerHandHeldModels(event -> event.register(RCItems.SPEAR.get(), SPEAR_HANDHELD_MODEL));
        GameRendering.registerSkullRenderers(ClientSetup::skullRendererRegistry);
        GameRendering.registerBlockRenderers(ClientSetup::blockRendererRegistry);
        VanillaCreativeTabIntegration.modifyVanillaCreativeTabs();
    }

    public static void modelLayerRegistry(GameRendering.ModelLayerEvent event) {
        CubeDeformation none = CubeDeformation.f_171458_;
        CubeDeformation outerLayer = new CubeDeformation(0.25f);
        CubeDeformation innerArmor = new CubeDeformation(0.5f);
        CubeDeformation outerArmor = new CubeDeformation(1.0f);
        LayerDefinition innerArmorLayer = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)innerArmor, (float)0.0f), (int)64, (int)32);
        LayerDefinition outerArmorLayer = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)outerArmor, (float)0.0f), (int)64, (int)32);
        event.register(RCModelLayers.TREASURE_CHEST, TreasureChestBlockModel::createBodyLayer);
        event.register(RCModelLayers.BURNED, BurnedModel::createBodyLayer);
        event.register(RCModelLayers.BURNED_HEAD, BurnedSkullModel::createMobHeadLayer);
        event.register(RCModelLayers.BURNED_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.BURNED_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.FROSTBITTEN, FrostbittenModel::createBodyLayer);
        event.register(RCModelLayers.FROSTBITTEN_HEAD, FrostbittenSkullModel::createMobHeadLayer);
        event.register(RCModelLayers.FROSTBITTEN_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.FROSTBITTEN_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.SWAMPY, SwampyModel::createBodyLayer);
        event.register(RCModelLayers.SWAMPY_HEAD, SwampySkullModel::createMobHeadLayer);
        event.register(RCModelLayers.SWAMPY_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.SWAMPY_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.UNDEAD_MINER, UndeadMinerModel::createBodyLayer);
        event.register(RCModelLayers.UNDEAD_MINER_HEAD, UndeadMinerSkullModel::createMobHeadLayer);
        event.register(RCModelLayers.UNDEAD_MINER_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.UNDEAD_MINER_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.MUMMY, MummyModel::createBodyLayer);
        event.register(RCModelLayers.MUMMY_HEAD, MummySkullModel::createMobHeadLayer);
        event.register(RCModelLayers.MUMMY_INNER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)innerArmor.m_171469_(0.25f), (float)0.0f), (int)64, (int)32));
        event.register(RCModelLayers.MUMMY_OUTER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)outerArmor.m_171469_(0.25f), (float)0.0f), (int)64, (int)32));
        event.register(RCModelLayers.GLACIAL_HUNTER, GlacialHunterModel::createBodyLayer);
        event.register(RCModelLayers.GLACIAL_HUNTER_HEAD, GlacialHunterSkullModel::createMobHeadLayer);
        event.register(RCModelLayers.HUNTER_WOLF, WolfModel::m_171088_);
        event.register(RCModelLayers.DEAD_BEARD, DeadBeardModel::createBodyLayer);
        event.register(RCModelLayers.DEAD_BEARD_HEAD, DeadBeardSkullModel::createMobHeadLayer);
        event.register(RCModelLayers.ZOMBIE_LACKEY, () -> DrownedModel.m_170535_((CubeDeformation)none));
        event.register(RCModelLayers.ZOMBIE_LACKEY_OUTER_LAYER, () -> DrownedModel.m_170535_((CubeDeformation)outerLayer));
        event.register(RCModelLayers.ZOMBIE_LACKEY_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.ZOMBIE_LACKEY_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.SKELETON_LACKEY, SkeletonModel::m_170942_);
        event.register(RCModelLayers.SKELETON_LACKEY_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.SKELETON_LACKEY_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.IMMORTAL, ImmortalModel::createBodyLayer);
        event.register(RCModelLayers.IMMORTAL_HEAD, ImmortalSkullModel::createMobHeadLayer);
        event.register(RCModelLayers.IMMORTAL_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.IMMORTAL_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.IMMORTAL_OVERLAY, ImmortalOverlayModel::createLayer);
        event.register(RCModelLayers.IMMORTAL_DASH, DashAttackLayer::createLayer);
        event.register(RCModelLayers.ZAP, ZapModel::createBodyLayer);
        event.register(RCModelLayers.ZAP_HEAD, ZapSkullModel::createMobHeadLayer);
        event.register(RCModelLayers.ZAP_INNER_ARMOR, () -> innerArmorLayer);
        event.register(RCModelLayers.ZAP_OUTER_ARMOR, () -> outerArmorLayer);
        event.register(RCModelLayers.SCARAB, ScarabModel::createBodyLayer);
    }

    public static void entityRendererRegistry(GameRendering.EntityRendererEvent event) {
        event.register(RCEntityTypes.TNT_BARREL.get(), TntBarrelRenderer::new);
        event.register(RCEntityTypes.BURNED.get(), BurnedRenderer::new);
        event.register(RCEntityTypes.FROSTBITTEN.get(), FrostbittenRenderer::new);
        event.register(RCEntityTypes.SWAMPY.get(), SwampyRenderer::new);
        event.register(RCEntityTypes.UNDEAD_MINER.get(), UndeadMinerRenderer::new);
        event.register(RCEntityTypes.MUMMY.get(), MummyRenderer::new);
        event.register(RCEntityTypes.GLACIAL_HUNTER.get(), GlacialHunterRenderer::new);
        event.register(RCEntityTypes.HUNTER_WOLF.get(), HunterWolfRenderer::new);
        event.register(RCEntityTypes.DEAD_BEARD.get(), DeadBeardRenderer::new);
        event.register(RCEntityTypes.ZOMBIE_LACKEY.get(), ZombieLackeyRenderer::new);
        event.register(RCEntityTypes.SKELETON_LACKEY.get(), SkeletonLackeyRenderer::new);
        event.register(RCEntityTypes.IMMORTAL.get(), ImmortalRenderer::new);
        event.register(RCEntityTypes.ZAP.get(), ZapRenderer::new);
        event.register(RCEntityTypes.SCARAB.get(), ScarabRenderer::new);
    }

    public static void blockEntityRendererRegistry(GameRendering.BlockEntityRendererEvent event) {
        event.register(RCBlockEntityTypes.TREASURE_CHEST.get(), TreasureChestBlockRenderer::new);
        event.register(RCBlockEntityTypes.SKULL.get(), SkullBlockRenderer::new);
    }

    public static void blockRendererRegistry(GameRendering.BlockRendererEvent event) {
        event.register(RenderType.m_110463_(), new Block[]{RCBlocks.TREASURE_CHEST.get()});
    }

    public static void skullRendererRegistry(GameRendering.SkullRendererEvent event) {
        event.registerSkullModel((SkullBlock.Type)SkullTypes.BURNED, BurnedSkullModel::new, RCModelLayers.BURNED_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.BURNED, RottenCreatures.resource("textures/entity/burned/burned.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.FROSTBITTEN, FrostbittenSkullModel::new, RCModelLayers.FROSTBITTEN_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.FROSTBITTEN, RottenCreatures.resource("textures/entity/frostbitten.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.SWAMPY, SwampySkullModel::new, RCModelLayers.SWAMPY_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.SWAMPY, RottenCreatures.resource("textures/entity/swampy.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.UNDEAD_MINER, UndeadMinerSkullModel::new, RCModelLayers.UNDEAD_MINER_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.UNDEAD_MINER, RottenCreatures.resource("textures/entity/undead_miner/undead_miner_stone.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.MUMMY, MummySkullModel::new, RCModelLayers.MUMMY_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.MUMMY, RottenCreatures.resource("textures/entity/mummy/mummy.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.GLACIAL_HUNTER, GlacialHunterSkullModel::new, RCModelLayers.GLACIAL_HUNTER_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.GLACIAL_HUNTER, RottenCreatures.resource("textures/entity/glacial_hunter.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.DEAD_BEARD, DeadBeardSkullModel::new, RCModelLayers.DEAD_BEARD_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.DEAD_BEARD, RottenCreatures.resource("textures/entity/dead_beard.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.IMMORTAL, ImmortalSkullModel::new, RCModelLayers.IMMORTAL_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.IMMORTAL, RottenCreatures.resource("textures/entity/immortal/immortal.png"));
        event.registerSkullModel((SkullBlock.Type)SkullTypes.ZAP, ZapSkullModel::new, RCModelLayers.ZAP_HEAD);
        event.registerSkullTexture((SkullBlock.Type)SkullTypes.ZAP, RottenCreatures.resource("textures/entity/zap.png"));
    }
}

