/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.render.ShadedBlockSbbBuilder;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.client.model.data.ModelData;

public class SchematicRenderer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final Map<RenderType, SuperByteBuffer> bufferCache = new LinkedHashMap<RenderType, SuperByteBuffer>(SchematicRenderer.getLayerCount());
    private boolean changed;
    protected final SchematicLevel schematic;
    private final BlockPos anchor;
    private final List<BlockEntity> renderedBlockEntities = new ArrayList<BlockEntity>();
    private final BitSet shouldRenderBlockEntities = new BitSet();
    private final BitSet scratchErroredBlockEntities = new BitSet();

    public SchematicRenderer(SchematicLevel world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.changed = true;
        for (BlockEntity renderedBlockEntity : this.schematic.getRenderedBlockEntities()) {
            this.renderedBlockEntities.add(renderedBlockEntity);
        }
        this.shouldRenderBlockEntities.set(0, this.renderedBlockEntities.size());
    }

    public void update() {
        this.changed = true;
    }

    public void render(PoseStack ms, SuperRenderTypeBuffer buffers) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        if (this.changed) {
            this.redraw();
        }
        this.changed = false;
        this.bufferCache.forEach((layer, buffer) -> buffer.renderInto(ms, buffers.m_6299_(layer)));
        this.scratchErroredBlockEntities.clear();
        BlockEntityRenderHelper.renderBlockEntities(this.renderedBlockEntities, this.shouldRenderBlockEntities, this.scratchErroredBlockEntities, null, (Level)this.schematic, ms, null, (MultiBufferSource)buffers, AnimationTickHolder.getPartialTicks());
        this.shouldRenderBlockEntities.andNot(this.scratchErroredBlockEntities);
    }

    protected void redraw() {
        this.bufferCache.clear();
        for (RenderType layer : RenderType.m_110506_()) {
            SuperByteBuffer buffer = this.drawLayer(layer);
            if (buffer.isEmpty()) continue;
            this.bufferCache.put(layer, buffer);
        }
    }

    protected SuperByteBuffer drawLayer(RenderType layer) {
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer renderer = dispatcher.m_110937_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.poseStack;
        RandomSource random = objects.random;
        BlockPos.MutableBlockPos mutableBlockPos = objects.mutableBlockPos;
        SchematicLevel renderWorld = this.schematic;
        BoundingBox bounds = renderWorld.getBounds();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        renderWorld.renderMode = true;
        ModelBlockRenderer.m_111000_();
        for (BlockPos localPos : BlockPos.m_121976_((int)bounds.m_162395_(), (int)bounds.m_162396_(), (int)bounds.m_162398_(), (int)bounds.m_162399_(), (int)bounds.m_162400_(), (int)bounds.m_162401_())) {
            BlockPos.MutableBlockPos pos = mutableBlockPos.m_175306_((Vec3i)localPos, (Vec3i)this.anchor);
            BlockState state = renderWorld.m_8055_((BlockPos)pos);
            if (state.m_60799_() != RenderShape.MODEL) continue;
            BakedModel model = dispatcher.m_110910_(state);
            BlockEntity blockEntity = renderWorld.m_7702_(localPos);
            ModelData modelData = blockEntity != null ? blockEntity.getModelData() : ModelData.EMPTY;
            modelData = model.getModelData((BlockAndTintGetter)renderWorld, (BlockPos)pos, state, modelData);
            long seed = state.m_60726_((BlockPos)pos);
            random.m_188584_(seed);
            if (!model.getRenderTypes(state, random, modelData).contains(layer)) continue;
            poseStack.m_85836_();
            poseStack.m_252880_((float)localPos.m_123341_(), (float)localPos.m_123342_(), (float)localPos.m_123343_());
            renderer.tesselateBlock((BlockAndTintGetter)renderWorld, model, state, (BlockPos)pos, poseStack, (VertexConsumer)sbbBuilder, true, random, seed, OverlayTexture.f_118083_, modelData, layer);
            poseStack.m_85849_();
        }
        ModelBlockRenderer.m_111077_();
        renderWorld.renderMode = false;
        return sbbBuilder.end();
    }

    private static int getLayerCount() {
        return RenderType.m_110506_().size();
    }

    private static class ThreadLocalObjects {
        public final PoseStack poseStack = new PoseStack();
        public final RandomSource random = RandomSource.m_216343_();
        public final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }
}

