/*
 * Decompiled with CFR 0.152.
 */
package vhacd4;

import com.jme3.bullet.FillMode;
import com.jme3.bullet.NativePhysicsObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class Vhacd4Parameters
extends NativePhysicsObject
implements Cloneable {
    public static final Logger logger = Logger.getLogger(Vhacd4Parameters.class.getName());
    private boolean debug;

    public Vhacd4Parameters() {
        long objectId = Vhacd4Parameters.create();
        super.setNativeId(objectId);
        Vhacd4Parameters.setMaxNumVerticesPerCH(objectId, 32);
        Vhacd4Parameters.setResolution(objectId, 100000);
    }

    public void fromInputStream(InputStream is) throws IOException {
        try (DataInputStream dis = new DataInputStream(is);){
            this.setAsync(dis.readBoolean());
            this.setDebugEnabled(dis.readBoolean());
            int fillModeOrdinal = dis.readInt();
            FillMode fillMode = FillMode.values()[fillModeOrdinal];
            this.setFillMode(fillMode);
            this.setFindBestPlane(dis.readBoolean());
            this.setMaxHulls(dis.readInt());
            this.setMaxRecursion(dis.readInt());
            this.setMaxVerticesPerHull(dis.readInt());
            this.setMinEdgeLength(dis.readInt());
            this.setShrinkWrap(dis.readBoolean());
            this.setVolumePercentError(dis.readDouble());
            this.setVoxelResolution(dis.readInt());
        }
    }

    public boolean getDebugEnabled() {
        return this.debug;
    }

    public FillMode getFillMode() {
        long objectId = this.nativeId();
        int ordinal = Vhacd4Parameters.getFillMode(objectId);
        FillMode result = FillMode.values()[ordinal];
        return result;
    }

    public int getMaxHulls() {
        long objectId = this.nativeId();
        int result = Vhacd4Parameters.getMaxHulls(objectId);
        return result;
    }

    public int getMaxRecursion() {
        long objectId = this.nativeId();
        int result = Vhacd4Parameters.getMaxRecursion(objectId);
        return result;
    }

    public int getMaxVerticesPerHull() {
        long objectId = this.nativeId();
        int result = Vhacd4Parameters.getMaxNumVerticesPerCH(objectId);
        return result;
    }

    public int getMinEdgeLength() {
        long objectId = this.nativeId();
        int result = Vhacd4Parameters.getMinEdgeLength(objectId);
        return result;
    }

    public double getVolumePercentError() {
        long objectId = this.nativeId();
        double result = Vhacd4Parameters.getVolumePercentError(objectId);
        return result;
    }

    public int getVoxelResolution() {
        long objectId = this.nativeId();
        int result = Vhacd4Parameters.getResolution(objectId);
        return result;
    }

    public boolean isAsync() {
        long objectId = this.nativeId();
        boolean result = Vhacd4Parameters.isAsync(objectId);
        return result;
    }

    public boolean isFindBestPlane() {
        long objectId = this.nativeId();
        boolean result = Vhacd4Parameters.isFindBestPlane(objectId);
        return result;
    }

    public boolean isShrinkWrap() {
        long objectId = this.nativeId();
        boolean result = Vhacd4Parameters.isShrinkWrap(objectId);
        return result;
    }

    public void nextFillMode() {
        FillMode mode = this.getFillMode();
        switch (mode) {
            case FloodFill: {
                this.setFillMode(FillMode.RaycastFill);
                break;
            }
            case RaycastFill: {
                this.setFillMode(FillMode.SurfaceOnly);
                break;
            }
            case SurfaceOnly: {
                this.setFillMode(FillMode.FloodFill);
                break;
            }
            default: {
                throw new IllegalStateException("mode = " + (Object)((Object)mode));
            }
        }
    }

    public void setAsync(boolean setting) {
        long objectId = this.nativeId();
        Vhacd4Parameters.setAsync(objectId, setting);
    }

    public void setDebugEnabled(boolean setting) {
        this.debug = setting;
    }

    public void setFillMode(FillMode mode) {
        Validate.nonNull((Object)mode, "mode");
        long objectId = this.nativeId();
        int ordinal = mode.ordinal();
        Vhacd4Parameters.setFillMode(objectId, ordinal);
    }

    public void setFindBestPlane(boolean setting) {
        long objectId = this.nativeId();
        Vhacd4Parameters.setFindBestPlane(objectId, setting);
    }

    public void setMaxHulls(int limit) {
        Validate.inRange(limit, "limit", 1, 1024);
        long objectId = this.nativeId();
        Vhacd4Parameters.setMaxHulls(objectId, limit);
    }

    public void setMaxRecursion(int depth) {
        Validate.inRange(depth, "depth", 2, 64);
        long objectId = this.nativeId();
        Vhacd4Parameters.setMaxRecursion(objectId, depth);
    }

    public void setMaxVerticesPerHull(int limit) {
        Validate.inRange(limit, "limit", 4, 2048);
        long objectId = this.nativeId();
        Vhacd4Parameters.setMaxNumVerticesPerCH(objectId, limit);
    }

    public void setMinEdgeLength(int length) {
        Validate.inRange(length, "length", 1, 32);
        long objectId = this.nativeId();
        Vhacd4Parameters.setMinEdgeLength(objectId, length);
    }

    public void setShrinkWrap(boolean setting) {
        long objectId = this.nativeId();
        Vhacd4Parameters.setShrinkWrap(objectId, setting);
    }

    public void setVolumePercentError(double percentage) {
        Validate.inRange(percentage, "percentage", 0.0, 100.0);
        long objectId = this.nativeId();
        Vhacd4Parameters.setVolumePercentError(objectId, percentage);
    }

    public void setVoxelResolution(int maxVoxels) {
        Validate.inRange(maxVoxels, "maxVoxels", 10000, 64000000);
        long objectId = this.nativeId();
        Vhacd4Parameters.setResolution(objectId, maxVoxels);
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("async", this.isAsync());
        result.put("debug", this.debug);
        result.put("fillMode", (Object)this.getFillMode());
        result.put("findBest", this.isFindBestPlane());
        result.put("maxHulls", this.getMaxHulls());
        result.put("maxRecursion", this.getMaxRecursion());
        result.put("maxVerticesPH", this.getMaxVerticesPerHull());
        result.put("minEdge", this.getMinEdgeLength());
        result.put("resolution", this.getVoxelResolution());
        result.put("shrink", this.isShrinkWrap());
        result.put("volumeErr", this.getVolumePercentError());
        return result;
    }

    public void toOutputStream(OutputStream os) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(os);){
            dos.writeBoolean(this.isAsync());
            dos.writeBoolean(this.getDebugEnabled());
            int fillModeOrdinal = this.getFillMode().ordinal();
            dos.writeInt(fillModeOrdinal);
            dos.writeBoolean(this.isFindBestPlane());
            dos.writeInt(this.getMaxHulls());
            dos.writeInt(this.getMaxRecursion());
            dos.writeInt(this.getMaxVerticesPerHull());
            dos.writeInt(this.getMinEdgeLength());
            dos.writeBoolean(this.isShrinkWrap());
            dos.writeDouble(this.getVolumePercentError());
            dos.writeInt(this.getVoxelResolution());
        }
    }

    public Vhacd4Parameters clone() {
        try {
            Vhacd4Parameters clone = (Vhacd4Parameters)super.clone();
            long objectId = Vhacd4Parameters.create();
            clone.reassignNativeId(objectId);
            clone.setAsync(this.isAsync());
            clone.setFillMode(this.getFillMode());
            clone.setFindBestPlane(this.isFindBestPlane());
            clone.setMaxHulls(this.getMaxHulls());
            clone.setMaxRecursion(this.getMaxRecursion());
            clone.setMaxVerticesPerHull(this.getMaxVerticesPerHull());
            clone.setMinEdgeLength(this.getMinEdgeLength());
            clone.setShrinkWrap(this.isShrinkWrap());
            clone.setVolumePercentError(this.getVolumePercentError());
            clone.setVoxelResolution(this.getVoxelResolution());
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            Vhacd4Parameters other = (Vhacd4Parameters)otherObject;
            result = this.isAsync() == other.isAsync() && this.getDebugEnabled() == other.getDebugEnabled() && this.getFillMode() == other.getFillMode() && this.isFindBestPlane() == other.isFindBestPlane() && this.getMaxHulls() == other.getMaxHulls() && this.getMaxRecursion() == other.getMaxRecursion() && this.getMaxVerticesPerHull() == other.getMaxVerticesPerHull() && this.getMinEdgeLength() == other.getMinEdgeLength() && this.isShrinkWrap() == other.isShrinkWrap() && this.getVolumePercentError() == other.getVolumePercentError() && this.getVoxelResolution() == other.getVoxelResolution();
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 2 * hash + (this.isAsync() ? 1 : 0);
        hash = 2 * hash + (this.getDebugEnabled() ? 1 : 0);
        hash = 3 * hash + this.getFillMode().ordinal();
        hash = 2 * hash + (this.isFindBestPlane() ? 1 : 0);
        hash = 83 * hash + this.getMaxHulls();
        hash = 83 * hash + this.getMaxRecursion();
        hash = 83 * hash + this.getMaxVerticesPerHull();
        hash = 83 * hash + this.getMinEdgeLength();
        hash = 2 * hash + (this.isShrinkWrap() ? 1 : 0);
        hash = 83 * hash + Double.hashCode(this.getVolumePercentError());
        hash = 83 * hash + this.getVoxelResolution();
        return hash;
    }

    @Override
    public String toString() {
        String result = String.format("Vhacd4Parameters[%n async=%s  debug=%s  %s  findBest=%s%n maxHulls=%s  maxRecursion=%s  maxVerticesPH=%s  minEdge=%s%n resolution=%s  shrink=%s  volumeErr=%s%%%n]", new Object[]{this.isAsync(), this.getDebugEnabled(), this.getFillMode(), this.isFindBestPlane(), this.getMaxHulls(), this.getMaxRecursion(), this.getMaxVerticesPerHull(), this.getMinEdgeLength(), this.getVoxelResolution(), this.isShrinkWrap(), this.getVolumePercentError()});
        return result;
    }

    private static void freeNativeObject(long objectId) {
        assert (objectId != 0L);
        Vhacd4Parameters.finalizeNative(objectId);
    }

    private static native long create();

    private static native void finalizeNative(long var0);

    private static native int getFillMode(long var0);

    private static native int getMaxHulls(long var0);

    private static native int getMaxNumVerticesPerCH(long var0);

    private static native int getMaxRecursion(long var0);

    private static native int getMinEdgeLength(long var0);

    private static native int getResolution(long var0);

    private static native double getVolumePercentError(long var0);

    private static native boolean isAsync(long var0);

    private static native boolean isFindBestPlane(long var0);

    private static native boolean isShrinkWrap(long var0);

    private static native void setAsync(long var0, boolean var2);

    private static native void setFillMode(long var0, int var2);

    private static native void setFindBestPlane(long var0, boolean var2);

    private static native void setMaxHulls(long var0, int var2);

    private static native void setMaxNumVerticesPerCH(long var0, int var2);

    private static native void setMaxRecursion(long var0, int var2);

    private static native void setMinEdgeLength(long var0, int var2);

    private static native void setResolution(long var0, int var2);

    private static native void setShrinkWrap(long var0, boolean var2);

    private static native void setVolumePercentError(long var0, double var2);
}

