/*
 * Decompiled with CFR 0.152.
 */
package vhacd4;

import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;
import vhacd.VHACDProgressListener;
import vhacd4.Vhacd4Hull;
import vhacd4.Vhacd4Parameters;

public final class Vhacd4 {
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(Vhacd4.class.getName());
    private static final Collection<VHACDProgressListener> progressListeners = new ArrayList<VHACDProgressListener>(4);
    private static List<Vhacd4Hull> results;

    private Vhacd4() {
    }

    public static void addProgressListener(VHACDProgressListener listener) {
        Validate.nonNull(listener, "listener");
        assert (!progressListeners.contains(listener));
        progressListeners.add(listener);
    }

    public static List<Vhacd4Hull> compute(float[] positions, int[] indices, Vhacd4Parameters params) {
        Validate.nonNull(positions, "positions");
        Validate.nonNull(indices, "indices");
        assert (positions.length % 3 == 0) : positions.length;
        assert (indices.length % 3 == 0) : indices.length;
        FloatBuffer positionsBuffer = BufferUtils.createFloatBuffer(positions);
        IntBuffer indexBuffer = BufferUtils.createIntBuffer(indices);
        results = new ArrayList<Vhacd4Hull>(50);
        Vhacd4.compute(positionsBuffer, indexBuffer, params.nativeId(), params.getDebugEnabled());
        return results;
    }

    public static void removeProgressListener(VHACDProgressListener listener) {
        Validate.nonNull(listener, "listener");
        boolean success = progressListeners.remove(listener);
        assert (success);
    }

    private static void addHull(long hullId) {
        Vhacd4Hull hull = new Vhacd4Hull(hullId);
        results.add(hull);
    }

    private static void update(double overallPercent, double stagePercent, double operationPercent, String stageName, String operationName) {
        for (VHACDProgressListener listener : progressListeners) {
            listener.update(overallPercent, stagePercent, operationPercent, stageName, operationName);
        }
    }

    private static native void compute(FloatBuffer var0, IntBuffer var1, long var2, boolean var4);
}

