/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class RectangularSolid {
    public static final Logger logger = Logger.getLogger(RectangularSolid.class.getName());
    private final Quaternion localToWorld = new Quaternion();
    private final Vector3f maxima = new Vector3f();
    private final Vector3f minima = new Vector3f();

    public RectangularSolid() {
    }

    public RectangularSolid(Vector3f halfExtents) {
        this.maxima.set(halfExtents);
        halfExtents.mult(-1.0f, this.minima);
    }

    public Vector3f halfExtents(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        this.maxima.subtract(this.minima, result);
        result.divideLocal(2.0f);
        assert (result.x >= 0.0f) : result.x;
        assert (result.y >= 0.0f) : result.y;
        assert (result.z >= 0.0f) : result.z;
        return result;
    }

    public Vector3f localToWorld(Vector3f local, Vector3f storeResult) {
        Validate.finite(local, "local");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        this.localToWorld.mult(local, result);
        return result;
    }

    public Vector3f maxima(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.maxima.clone() : storeResult.set(this.maxima);
        return result;
    }

    public Vector3f minima(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.minima.clone() : storeResult.set(this.minima);
        return result;
    }

    public String toString() {
        String description = "RectangularSolid[" + this.localToWorld + ", min=" + this.minima + ", max=" + this.maxima + "]";
        return description;
    }
}

