/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public final class MyVector3f {
    public static final int firstAxis = 0;
    public static final int numAxes = 3;
    public static final int xAxis = 0;
    public static final int yAxis = 1;
    public static final int zAxis = 2;
    public static final int lastAxis = 2;
    public static final Logger logger = Logger.getLogger(MyVector3f.class.getName());

    private MyVector3f() {
    }

    public static void accumulateMaxima(Vector3f maxima, Vector3f input) {
        if (input.x > maxima.x) {
            maxima.x = input.x;
        }
        if (input.y > maxima.y) {
            maxima.y = input.y;
        }
        if (input.z > maxima.z) {
            maxima.z = input.z;
        }
    }

    public static void accumulateMinima(Vector3f minima, Vector3f input) {
        if (input.x < minima.x) {
            minima.x = input.x;
        }
        if (input.y < minima.y) {
            minima.y = input.y;
        }
        if (input.z < minima.z) {
            minima.z = input.z;
        }
    }

    public static void accumulateScaled(Vector3f total, Vector3f input, float scale) {
        assert (Validate.nonNull(total, "total"));
        assert (Validate.nonNull(input, "input"));
        total.x += input.x * scale;
        total.y += input.y * scale;
        total.z += input.z * scale;
    }

    public static double dot(Vector3f vector1, Vector3f vector2) {
        double x1 = vector1.x;
        double x2 = vector2.x;
        double y1 = vector1.y;
        double y2 = vector2.y;
        double z1 = vector1.z;
        double z2 = vector2.z;
        double product = x1 * x2 + y1 * y2 + z1 * z2;
        return product;
    }

    public static void generateBasis(Vector3f in1, Vector3f store2, Vector3f store3) {
        assert (Validate.nonZero(in1, "starting direction"));
        assert (Validate.nonNull(store2, "2nd basis vector"));
        assert (Validate.nonNull(store3, "3nd basis vector"));
        MyVector3f.normalizeLocal(in1);
        float x = Math.abs(in1.x);
        float y = Math.abs(in1.y);
        float z = Math.abs(in1.z);
        if (x <= y && x <= z) {
            store3.set(1.0f, 0.0f, 0.0f);
        } else if (y <= z) {
            store3.set(0.0f, 1.0f, 0.0f);
        } else {
            store3.set(0.0f, 0.0f, 1.0f);
        }
        in1.cross(store3, store2);
        MyVector3f.normalizeLocal(store2);
        in1.cross(store2, store3);
        MyVector3f.normalizeLocal(store3);
    }

    public static boolean isAllNonNegative(Vector3f vector) {
        return vector.x >= 0.0f && vector.y >= 0.0f && vector.z >= 0.0f;
    }

    public static boolean isAllPositive(Vector3f vector) {
        return vector.x > 0.0f && vector.y > 0.0f && vector.z > 0.0f;
    }

    public static boolean isScaleIdentity(Vector3f vector) {
        return vector.x == 1.0f && vector.y == 1.0f && vector.z == 1.0f;
    }

    public static boolean isScaleUniform(Vector3f vector) {
        return vector.x == vector.y && vector.y == vector.z;
    }

    public static boolean isZero(Vector3f vector) {
        return vector.x == 0.0f && vector.y == 0.0f && vector.z == 0.0f;
    }

    public static double lengthSquared(Vector3f vector) {
        double result = MyMath.sumOfSquares(vector.x, vector.y, vector.z);
        return result;
    }

    public static Vector3f lerp(float t, Vector3f v0, Vector3f v1, Vector3f storeResult) {
        assert (Validate.nonNull(v0, "v0"));
        assert (Validate.nonNull(v1, "v1"));
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.x = MyMath.lerp(t, v0.x, v1.x);
        result.y = MyMath.lerp(t, v0.y, v1.y);
        result.z = MyMath.lerp(t, v0.z, v1.z);
        return result;
    }

    public static Vector3f midpoint(Vector3f vector1, Vector3f vector2, Vector3f storeResult) {
        assert (Validate.finite(vector1, "first location"));
        assert (Validate.finite(vector2, "2nd location"));
        float x = (vector1.x + vector2.x) / 2.0f;
        float y = (vector1.y + vector2.y) / 2.0f;
        float z = (vector1.z + vector2.z) / 2.0f;
        if (storeResult == null) {
            return new Vector3f(x, y, z);
        }
        return storeResult.set(x, y, z);
    }

    public static boolean ne(Vector3f v1, Vector3f v2) {
        assert (Validate.nonNull(v1, "first input vector"));
        assert (Validate.nonNull(v2, "2nd input vector"));
        boolean result = v1.x != v2.x || v1.y != v2.y || v1.z != v2.z;
        return result;
    }

    public static void normalizeLocal(Vector3f input) {
        assert (Validate.nonNull(input, "input"));
        double lengthSquared = MyVector3f.lengthSquared(input);
        double dScale = Math.sqrt(lengthSquared);
        float fScale = (float)dScale;
        if (fScale != 0.0f && fScale != 1.0f) {
            input.divideLocal(fScale);
        }
    }

    public static Vector3f standardize(Vector3f input, Vector3f storeResult) {
        assert (Validate.nonNull(input, "input vector"));
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.x = MyMath.standardize(input.x);
        result.y = MyMath.standardize(input.y);
        result.z = MyMath.standardize(input.z);
        return result;
    }
}

