/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public final class MyMath {
    public static final float phi = (1.0f + FastMath.sqrt(5.0f)) / 2.0f;
    public static final float root2 = FastMath.sqrt(2.0f);
    public static final float rootHalf = FastMath.sqrt(0.5f);
    public static final Logger logger = Logger.getLogger(MyMath.class.getName());

    private MyMath() {
    }

    public static double clamp(double dValue, double min, double max) {
        double result = dValue < min ? min : (dValue > max ? max : dValue);
        return result;
    }

    public static float cube(float fValue) {
        float result = fValue * fValue * fValue;
        if (Float.isInfinite(result)) {
            String message = String.format("Overflow from cubing %g.", Float.valueOf(fValue));
            logger.warning(message);
        }
        return result;
    }

    public static Matrix3f fromAngles(float xAngle, float yAngle, float zAngle, Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        float c1 = FastMath.cos(yAngle);
        float c2 = FastMath.cos(zAngle);
        float c3 = FastMath.cos(xAngle);
        float s1 = FastMath.sin(yAngle);
        float s2 = FastMath.sin(zAngle);
        float s3 = FastMath.sin(xAngle);
        result.set(0, 0, c1 * c2);
        result.set(0, 1, s1 * s3 - c1 * c3 * s2);
        result.set(0, 2, c3 * s1 + c1 * s2 * s3);
        result.set(1, 0, s2);
        result.set(1, 1, c2 * c3);
        result.set(1, 2, -c2 * s3);
        result.set(2, 0, -c2 * s1);
        result.set(2, 1, c1 * s3 + c3 * s1 * s2);
        result.set(2, 2, c1 * c3 - s1 * s2 * s3);
        return result;
    }

    public static float hypotenuse(float ... fValues) {
        double sum = 0.0;
        for (float fValue : fValues) {
            double value = fValue;
            sum += value * value;
        }
        float result = (float)Math.sqrt(sum);
        assert (result >= 0.0f) : result;
        return result;
    }

    public static double hypotenuseDouble(double ... dValues) {
        double sum = 0.0;
        for (double value : dValues) {
            sum += value * value;
        }
        double result = Math.sqrt(sum);
        assert (result >= 0.0) : result;
        return result;
    }

    public static boolean isBetween(float a, float b, float c) {
        if (a > c) {
            return a >= b && b >= c;
        }
        if (a < c) {
            return a <= b && b <= c;
        }
        if (a == c) {
            return a == b;
        }
        String message = "a = " + a + " c = " + c;
        throw new IllegalArgumentException(message);
    }

    public static boolean isFinite(float value) {
        if (Float.isInfinite(value)) {
            return false;
        }
        return !Float.isNaN(value);
    }

    public static boolean isFinite(Vec3d vector) {
        if (vector == null) {
            return false;
        }
        return MyMath.isFiniteDouble(vector.x) && MyMath.isFiniteDouble(vector.y) && MyMath.isFiniteDouble(vector.z);
    }

    public static boolean isFiniteDouble(double value) {
        if (Double.isInfinite(value)) {
            return false;
        }
        return !Double.isNaN(value);
    }

    public static boolean isIdentity(Transform transform) {
        Quaternion rotation;
        boolean result = false;
        Vector3f translation = transform.getTranslation();
        if (MyVector3f.isZero(translation) && MyQuaternion.isRotationIdentity(rotation = transform.getRotation())) {
            Vector3f scale = transform.getScale();
            result = MyVector3f.isScaleIdentity(scale);
        }
        return result;
    }

    public static boolean isOdd(int iValue) {
        boolean result = iValue % 2 != 0;
        return result;
    }

    public static float lerp(float t, float y0, float y1) {
        float result;
        if (y0 == y1) {
            result = y0;
        } else {
            float u = 1.0f - t;
            result = u * y0 + t * y1;
        }
        return result;
    }

    public static float max(float ... fValues) {
        float result = Float.NEGATIVE_INFINITY;
        for (float value : fValues) {
            if (!(value > result)) continue;
            result = value;
        }
        return result;
    }

    public static float mid(float a, float b, float c) {
        if (a >= b) {
            if (b >= c) {
                return b;
            }
            if (a >= c) {
                return c;
            }
            return a;
        }
        if (a >= c) {
            return a;
        }
        if (b >= c) {
            return c;
        }
        return b;
    }

    public static float min(float ... fValues) {
        float result = Float.POSITIVE_INFINITY;
        for (float value : fValues) {
            if (!(value < result)) continue;
            result = value;
        }
        return result;
    }

    public static int modulo(int iValue, int modulus) {
        assert (Validate.positive(modulus, "modulus"));
        int remainder = iValue % modulus;
        int result = iValue >= 0 ? remainder : (remainder + modulus) % modulus;
        assert ((float)result >= 0.0f) : result;
        assert (result < modulus) : result;
        return result;
    }

    public static float modulo(float fValue, float modulus) {
        assert (Validate.positive(modulus, "modulus"));
        float remainder = fValue % modulus;
        float result = fValue >= 0.0f ? remainder : (remainder + modulus) % modulus;
        assert (result >= 0.0f) : result;
        assert (result < modulus) : result;
        return result;
    }

    public static float standardize(float fValue) {
        float result = fValue;
        if (Float.compare(fValue, -0.0f) == 0) {
            result = 0.0f;
        }
        return result;
    }

    public static float standardizeAngle(float angle) {
        Validate.finite(angle, "angle");
        float result = MyMath.modulo(angle, (float)Math.PI * 2);
        if (result >= (float)Math.PI) {
            result -= (float)Math.PI * 2;
        }
        assert (result >= (float)(-Math.PI)) : result;
        assert (result < (float)Math.PI) : result;
        return result;
    }

    public static double sumOfSquares(float ... fValues) {
        double result = 0.0;
        for (float fValue : fValues) {
            double value = fValue;
            result += value * value;
        }
        assert (result >= 0.0) : result;
        return result;
    }

    public static float toDegrees(float radians) {
        float result = radians * 57.295776f;
        return result;
    }

    public static float toRadians(float degrees) {
        float result = degrees * ((float)Math.PI / 180);
        return result;
    }

    public static Triangle transformInverse(Transform transform, Triangle input, Triangle storeResult) {
        Triangle result = storeResult == null ? new Triangle() : storeResult;
        Vector3f tmpVector = new Vector3f();
        for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
            Vector3f inputVector = input.get(vertexIndex);
            transform.transformInverseVector(inputVector, tmpVector);
            result.set(vertexIndex, tmpVector);
        }
        return result;
    }
}

