/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;

public final class MyBuffer {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(MyBuffer.class.getName());

    private MyBuffer() {
    }

    public static Matrix3f covariance(FloatBuffer buffer, int startPosition, int endPosition, Matrix3f storeResult) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition - 6);
        Validate.inRange(endPosition, "end position", startPosition + 6, buffer.capacity());
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        Vector3f sampleMean = MyBuffer.mean(buffer, startPosition, endPosition, null);
        result.zero();
        float[] aboveMean = new float[3];
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            aboveMean[0] = x - sampleMean.x;
            aboveMean[1] = y - sampleMean.y;
            aboveMean[2] = z - sampleMean.z;
            for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
                for (int colIndex = rowIndex; colIndex < 3; ++colIndex) {
                    float sum = result.get(rowIndex, colIndex);
                    result.set(rowIndex, colIndex, sum += aboveMean[rowIndex] * aboveMean[colIndex]);
                }
            }
        }
        float nMinus1 = numVectors - 1;
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int colIndex = rowIndex; colIndex < 3; ++colIndex) {
                float sum = result.get(rowIndex, colIndex);
                float element = sum / nMinus1;
                result.set(rowIndex, colIndex, element);
                result.set(colIndex, rowIndex, element);
            }
        }
        return result;
    }

    public static float cylinderRadius(FloatBuffer buffer, int startPosition, int endPosition, int axisIndex) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        Validate.axisIndex(axisIndex, "axis index");
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        double maxRadiusSquared = 0.0;
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            float radiusSquared;
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            switch (axisIndex) {
                case 0: {
                    radiusSquared = y * y + z * z;
                    break;
                }
                case 1: {
                    radiusSquared = x * x + z * z;
                    break;
                }
                case 2: {
                    radiusSquared = x * x + y * y;
                    break;
                }
                default: {
                    String message = Integer.toString(axisIndex);
                    throw new RuntimeException(message);
                }
            }
            if (!((double)radiusSquared > maxRadiusSquared)) continue;
            maxRadiusSquared = radiusSquared;
        }
        float result = (float)Math.sqrt(maxRadiusSquared);
        assert (result >= 0.0f) : result;
        return result;
    }

    public static FloatBuffer ensureCapacity(int minFloats, FloatBuffer bufferToReuse) {
        FloatBuffer result;
        Validate.nonNegative(minFloats, "minimum number of elements");
        if (bufferToReuse == null) {
            result = BufferUtils.createFloatBuffer(minFloats);
        } else {
            int capacityFloats = bufferToReuse.capacity();
            if (capacityFloats < minFloats) {
                logger.log(Level.SEVERE, "capacity={0}", capacityFloats);
                String message = String.format("Buffer capacity must be greater than or equal to %d.", minFloats);
                throw new IllegalArgumentException(message);
            }
            result = bufferToReuse;
        }
        return result;
    }

    public static void get(FloatBuffer buffer, int startPosition, Vector3f storeVector) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNegative(startPosition, "start position");
        Validate.nonNull(storeVector, "store vector");
        storeVector.x = buffer.get(startPosition + 0);
        storeVector.y = buffer.get(startPosition + 1);
        storeVector.z = buffer.get(startPosition + 2);
    }

    public static Vector3f maxAbs(FloatBuffer buffer, int startPosition, int endPosition, Vector3f storeResult) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        result.zero();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            result.x = Math.max(result.x, Math.abs(x));
            result.y = Math.max(result.y, Math.abs(y));
            result.z = Math.max(result.z, Math.abs(z));
        }
        return result;
    }

    public static float maxLength(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        double maxLengthSquared = 0.0;
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            float[] fArray = new float[]{x, y, z};
            double lengthSquared = MyMath.sumOfSquares(fArray);
            if (!(lengthSquared > maxLengthSquared)) continue;
            maxLengthSquared = lengthSquared;
        }
        float result = (float)Math.sqrt(maxLengthSquared);
        assert (result >= 0.0f) : result;
        return result;
    }

    public static void maxMin(FloatBuffer buffer, int startPosition, int endPosition, Vector3f storeMaxima, Vector3f storeMinima) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        storeMaxima.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        storeMinima.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f tmpVector = new Vector3f();
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            MyVector3f.accumulateMinima(storeMinima, tmpVector);
            MyVector3f.accumulateMaxima(storeMaxima, tmpVector);
        }
    }

    public static Vector3f mean(FloatBuffer buffer, int startPosition, int endPosition, Vector3f storeResult) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition - 3);
        Validate.inRange(endPosition, "end position", startPosition + 3, buffer.capacity());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        result.zero();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            result.addLocal(x, y, z);
        }
        result.divideLocal(numVectors);
        return result;
    }

    public static void put(FloatBuffer buffer, int startPosition, Vector3f vector) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNegative(startPosition, "start position");
        Validate.nonNull(vector, "vector");
        buffer.put(startPosition + 0, vector.x);
        buffer.put(startPosition + 1, vector.y);
        buffer.put(startPosition + 2, vector.z);
    }

    public static void rotate(FloatBuffer buffer, int startPosition, int endPosition, Quaternion rotation) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNull(rotation, "rotation");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        Vector3f tmpVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            rotation.mult(tmpVector, tmpVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }

    public static void transform(FloatBuffer buffer, int startPosition, int endPosition, Transform transform) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNull(transform, "transform");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        Vector3f tmpVector = new Vector3f();
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            transform.transformVector(tmpVector, tmpVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }

    public static void translate(FloatBuffer buffer, int startPosition, int endPosition, Vector3f offsetVector) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        Validate.finite(offsetVector, "offset vector");
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        Vector3f tmpVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            tmpVector.addLocal(offsetVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }
}

