/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.lbj;

import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jme3utilities.Validate;

public class IndexBuffer {
    private boolean mutable = true;
    private final Buffer buffer;
    private final ByteBuffer bytes;
    private final int lastVertexIndex;
    private final IntBuffer ints;
    private final ShortBuffer shorts;

    private IndexBuffer(Buffer dataBuffer) {
        this.buffer = dataBuffer;
        if (dataBuffer instanceof ByteBuffer) {
            this.lastVertexIndex = 255;
            this.bytes = (ByteBuffer)dataBuffer;
            this.ints = null;
            this.shorts = null;
        } else if (dataBuffer instanceof ShortBuffer) {
            this.lastVertexIndex = 65535;
            this.bytes = null;
            this.ints = null;
            this.shorts = (ShortBuffer)dataBuffer;
        } else if (dataBuffer instanceof IntBuffer) {
            this.lastVertexIndex = Integer.MAX_VALUE;
            this.bytes = null;
            this.ints = (IntBuffer)dataBuffer;
            this.shorts = null;
        } else {
            Class<?> clazz = dataBuffer.getClass();
            throw new IllegalArgumentException(clazz.getSimpleName());
        }
    }

    protected IndexBuffer(int maxVertices, int capacity) {
        this.lastVertexIndex = maxVertices - 1;
        if (this.lastVertexIndex < 256) {
            this.bytes = BufferUtils.createByteBuffer(capacity);
            this.ints = null;
            this.shorts = null;
            this.buffer = this.bytes;
        } else if (this.lastVertexIndex < 65536) {
            this.bytes = null;
            this.ints = null;
            this.shorts = BufferUtils.createShortBuffer(capacity);
            this.buffer = this.shorts;
        } else {
            this.bytes = null;
            this.ints = BufferUtils.createIntBuffer(capacity);
            this.shorts = null;
            this.buffer = this.ints;
        }
    }

    public Buffer copyBuffer() {
        if (this.bytes != null) {
            int numBytes = this.bytes.capacity();
            ByteBuffer result = BufferUtils.createByteBuffer(numBytes);
            for (int position = 0; position < numBytes; ++position) {
                byte index = this.bytes.get(position);
                result.put(position, index);
            }
            return result;
        }
        if (this.shorts != null) {
            int numShorts = this.shorts.capacity();
            ShortBuffer result = BufferUtils.createShortBuffer(numShorts);
            for (int position = 0; position < numShorts; ++position) {
                short index = this.shorts.get(position);
                result.put(position, index);
            }
            return result;
        }
        int numInts = this.ints.capacity();
        IntBuffer result = BufferUtils.createIntBuffer(numInts);
        for (int position = 0; position < numInts; ++position) {
            int index = this.ints.get(position);
            result.put(position, index);
        }
        return result;
    }

    public static IndexBuffer createIndexBuffer(int maxVertices, int capacity) {
        Validate.nonNegative(capacity, "capacity");
        Validate.positive(maxVertices, "max number of vertices");
        IndexBuffer result = new IndexBuffer(maxVertices, capacity);
        return result;
    }

    public int get(int position) {
        int result = this.bytes != null ? this.bytes.get(position) & 0xFF : (this.shorts != null ? this.shorts.get(position) & 0xFFFF : this.ints.get(position));
        assert (result >= 0 && result <= this.lastVertexIndex) : result;
        return result;
    }

    public boolean isDirect() {
        boolean result = this.buffer.isDirect();
        return result;
    }

    public IndexBuffer limit(int newLimit) {
        this.verifyMutable();
        this.buffer.limit(newLimit);
        return this;
    }

    public IndexBuffer put(int position, int index) {
        this.verifyMutable();
        Validate.inRange(index, "index", 0, this.lastVertexIndex);
        if (this.bytes != null) {
            this.bytes.put(position, (byte)index);
        } else if (this.shorts != null) {
            this.shorts.put(position, (short)index);
        } else {
            this.ints.put(position, index);
        }
        return this;
    }

    public int size() {
        int result = this.buffer.limit();
        return result;
    }

    public static IndexBuffer wrapIndexBuffer(Buffer dataBuffer) {
        Validate.nonNull(dataBuffer, "data buffer");
        IndexBuffer result = new IndexBuffer(dataBuffer);
        return result;
    }

    protected int get() {
        int result = this.bytes != null ? this.bytes.get() & 0xFF : (this.shorts != null ? this.shorts.get() & 0xFFFF : this.ints.get());
        assert (result >= 0 && result <= this.lastVertexIndex) : result;
        return result;
    }

    protected Buffer getBuffer() {
        assert (this.buffer != null);
        return this.buffer;
    }

    protected IndexBuffer makeImmutable() {
        this.mutable = false;
        return this;
    }

    protected IndexBuffer put(int index) {
        this.verifyMutable();
        Validate.inRange(index, "index", 0, this.lastVertexIndex);
        if (this.bytes != null) {
            this.bytes.put((byte)index);
        } else if (this.shorts != null) {
            this.shorts.put((short)index);
        } else {
            this.ints.put(index);
        }
        return this;
    }

    protected void verifyMutable() {
        if (!this.mutable) {
            throw new IllegalStateException("The index buffer is no longer mutable.");
        }
    }
}

