/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public final class Validate {
    public static final Logger logger = Logger.getLogger(Validate.class.getName());
    public static boolean throwNpe = true;

    private Validate() {
    }

    public static boolean axisIndex(int iValue, String description) {
        Validate.inRange(iValue, description, 0, 2);
        return true;
    }

    public static boolean finite(float fValue, String description) {
        if (!Float.isFinite(fValue)) {
            String what = description == null ? "float argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, Float.valueOf(fValue)});
            String message = what + " must be a finite number.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean finite(Vector3f vector, String description) {
        Validate.nonNull(vector, description);
        if (!Vector3f.isValidVector(vector)) {
            String what = description == null ? "Vector3f argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, vector});
            String message = what + " must have all components finite.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean finite(Vec3d vector, String description) {
        Validate.nonNull(vector, description);
        if (!MyMath.isFinite(vector)) {
            String what = description == null ? "Vec3d argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, vector});
            String message = what + " must have all components finite.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean fraction(float fValue, String description) {
        Validate.inRange(fValue, description, 0.0f, 1.0f);
        return true;
    }

    public static boolean fraction(double dValue, String description) {
        Validate.inRange(dValue, description, 0.0, 1.0);
        return true;
    }

    public static boolean inRange(int iValue, String description, int min, int max) {
        if (iValue < min) {
            String what = description == null ? "int argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, iValue});
            String message = String.format("%s must be greater than or equal to %d.", what, min);
            throw new IllegalArgumentException(message);
        }
        if (iValue > max) {
            String what = description == null ? "int argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, iValue});
            String message = String.format("%s must be less than or equal to %d.", what, max);
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean inRange(float fValue, String description, float min, float max) {
        if (!(fValue >= min)) {
            String what = description == null ? "float argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, Float.valueOf(fValue)});
            String message = String.format("%s must be greater than or equal to %f.", what, Float.valueOf(min));
            throw new IllegalArgumentException(message);
        }
        if (!(fValue <= max)) {
            String what = description == null ? "float argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, Float.valueOf(fValue)});
            String message = String.format("%s must be less than or equal to %f.", what, Float.valueOf(max));
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean inRange(double dValue, String description, double min, double max) {
        if (!(dValue >= min)) {
            String what = description == null ? "double argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, dValue});
            String message = String.format("%s must be greater than or equal to %f.", what, min);
            throw new IllegalArgumentException(message);
        }
        if (!(dValue <= max)) {
            String what = description == null ? "double argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, dValue});
            String message = String.format("%s must be less than or equal to %f.", what, max);
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonEmpty(Collection collection, String description) {
        Validate.nonNull(collection, description);
        if (collection.isEmpty()) {
            String what = description == null ? "Collection argument" : description;
            String message = what + " must not be empty.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonEmpty(float[] array, String description) {
        Validate.nonNull(array, description);
        if (array.length == 0) {
            String what = description == null ? "float[] argument" : description;
            String message = what + " must not be empty.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonEmpty(Object[] array, String description) {
        Validate.nonNull(array, description);
        if (array.length == 0) {
            String what = description == null ? "Object[] argument" : description;
            String message = what + " must not be empty.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonEmpty(String string, String description) {
        Validate.nonNull(string, description);
        if (string.isEmpty()) {
            String what = description == null ? "String argument" : description;
            String message = what + " must not be empty.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonNegative(int iValue, String description) {
        if (iValue < 0) {
            String what = description == null ? "int argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, iValue});
            String message = what + " must not be negative.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonNegative(float fValue, String description) {
        if (!(fValue >= 0.0f)) {
            String what = description == null ? "float argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, Float.valueOf(fValue)});
            String message = what + " must not be negative.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonNegative(Vector3f vector, String description) {
        Validate.nonNull(vector, description);
        if (!MyVector3f.isAllNonNegative(vector)) {
            String what = description == null ? "Vector3f argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, vector});
            String message = what + " must not have a negative component.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonNull(Object object, String description) {
        if (object == null) {
            String what = description == null ? "Object argument" : description;
            String message = what + " must not be null.";
            if (throwNpe) {
                throw new NullPointerException(message);
            }
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonZero(long lValue, String description) {
        if (lValue == 0L) {
            String what = description == null ? "long argument" : description;
            String message = what + " must not be zero.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonZero(Quaternion quaternion, String description) {
        Validate.nonNull(quaternion, description);
        if (MyQuaternion.isZero(quaternion)) {
            String what = description == null ? "Quaternion argument" : description;
            String message = what + " must not be zero.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonZero(Quatd quaternion, String description) {
        Validate.nonNull(quaternion, description);
        if (quaternion.isZero()) {
            String what = description == null ? "Quatd argument" : description;
            String message = what + " must not be zero.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean nonZero(Vector3f vector, String description) {
        Validate.nonNull(vector, description);
        if (MyVector3f.isZero(vector)) {
            String what = description == null ? "Vector3f argument" : description;
            String message = what + " must not be zero.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean positive(int iValue, String description) {
        if (iValue <= 0) {
            String what = description == null ? "int argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, iValue});
            String message = what + " must be positive.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean positive(float fValue, String description) {
        if (!(fValue > 0.0f)) {
            String what = description == null ? "float argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, Float.valueOf(fValue)});
            String message = what + " must be positive.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean positive(Vector3f vector, String description) {
        Validate.nonNull(vector, description);
        if (!MyVector3f.isAllPositive(vector)) {
            String what = description == null ? "Vector3f argument" : description;
            logger.log(Level.SEVERE, "{0}={1}", new Object[]{what, vector});
            String message = what + " must have all components positive.";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean require(boolean value, String what) {
        if (!value) {
            String message = what == null ? "" : "Must have " + what + ".";
            throw new IllegalArgumentException(message);
        }
        return true;
    }
}

