/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public final class MyString {
    private static final Logger logger = Logger.getLogger(MyString.class.getName());

    private MyString() {
    }

    public static String escape(CharSequence unescaped) {
        int length = unescaped.length();
        StringBuilder result = new StringBuilder(length + 10);
        block6: for (int i = 0; i < length; ++i) {
            char ch = unescaped.charAt(i);
            switch (ch) {
                case '\n': {
                    result.append("\\n");
                    continue block6;
                }
                case '\t': {
                    result.append("\\t");
                    continue block6;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static String firstToLower(String input) {
        String result = input;
        if (!input.isEmpty()) {
            String first = input.substring(0, 1);
            first = first.toLowerCase(Locale.ROOT);
            String rest = input.substring(1);
            result = first + rest;
        }
        return result;
    }

    public static String quote(CharSequence text) {
        String result = text == null ? "null" : "\"" + MyString.escape(text) + "\"";
        return result;
    }

    public static String removeSuffix(String input, String suffix) {
        Validate.nonNull(suffix, "suffix");
        if (!input.endsWith(suffix)) {
            logger.log(Level.SEVERE, "input={0}, suffix={1}", new Object[]{MyString.quote(input), MyString.quote(suffix)});
            throw new IllegalArgumentException("input must end with suffix.");
        }
        int endPosition = input.length() - suffix.length();
        String result = input.substring(0, endPosition);
        assert (result != null);
        return result;
    }
}

