/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.util.debug;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.lazurite.rayon.api.event.render.DebugRenderEvents;
import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.MinecraftRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.shape.MinecraftShape;
import dev.lazurite.rayon.impl.bullet.collision.body.shape.Triangle;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;

public final class CollisionObjectDebugger {
    private static boolean enabled;

    private CollisionObjectDebugger() {
    }

    public static boolean toggle() {
        enabled = !enabled;
        return enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void renderSpace(MinecraftSpace space, PoseStack stack, float tickDelta) {
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        DebugRenderEvents.BEFORE_RENDER.invoke(new Object[]{new DebugRenderEvents.Context(space, (VertexConsumer)builder, stack, cameraPos, tickDelta)});
        builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        RenderSystem.setShader(GameRenderer::m_172811_);
        space.getTerrainMap().values().forEach(terrain -> CollisionObjectDebugger.renderBody(terrain, builder, stack, tickDelta));
        space.getRigidBodiesByClass(ElementRigidBody.class).forEach(elementRigidBody -> CollisionObjectDebugger.renderBody(elementRigidBody, builder, stack, tickDelta));
        Tesselator.m_85913_().m_85914_();
    }

    public static void renderBody(MinecraftRigidBody rigidBody, BufferBuilder builder, PoseStack stack, float tickDelta) {
        Vector3f position = rigidBody.isStatic() ? rigidBody.getPhysicsLocation(new Vector3f()) : ((ElementRigidBody)rigidBody).getFrame().getLocation(new Vector3f(), tickDelta);
        Quaternion rotation = rigidBody.isStatic() ? rigidBody.getPhysicsRotation(new Quaternion()) : ((ElementRigidBody)rigidBody).getFrame().getRotation(new Quaternion(), tickDelta);
        CollisionObjectDebugger.renderShape(rigidBody.getMinecraftShape(), position, rotation, builder, stack, rigidBody.getOutlineColor(), 1.0f);
    }

    public static void renderShape(MinecraftShape shape, Vector3f position, Quaternion rotation, BufferBuilder builder, PoseStack stack, Vector3f color, float alpha) {
        List<Triangle> triangles = shape.getTriangles(Quaternion.IDENTITY);
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        for (Triangle triangle : triangles) {
            Vector3f[] vertices = triangle.getVertices();
            stack.m_85836_();
            stack.m_85837_((double)position.x - cameraPos.f_82479_, (double)position.y - cameraPos.f_82480_, (double)position.z - cameraPos.f_82481_);
            stack.m_252781_(Convert.toMinecraft(rotation));
            Vector3f p1 = vertices[0];
            Vector3f p2 = vertices[1];
            Vector3f p3 = vertices[2];
            builder.m_252986_(stack.m_85850_().m_252922_(), p1.x, p1.y, p1.z).m_85950_(color.x, color.y, color.z, alpha).m_5752_();
            builder.m_252986_(stack.m_85850_().m_252922_(), p2.x, p2.y, p2.z).m_85950_(color.x, color.y, color.z, alpha).m_5752_();
            builder.m_252986_(stack.m_85850_().m_252922_(), p3.x, p3.y, p3.z).m_85950_(color.x, color.y, color.z, alpha).m_5752_();
            builder.m_252986_(stack.m_85850_().m_252922_(), p1.x, p1.y, p1.z).m_85950_(color.x, color.y, color.z, alpha).m_5752_();
            stack.m_85849_();
        }
    }
}

