/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.util;

import com.jme3.math.Quaternion;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.toolbox.api.math.QuaternionHelper;
import dev.lazurite.toolbox.api.math.VectorHelper;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Frame {
    private com.jme3.math.Vector3f prevLocation;
    private com.jme3.math.Vector3f tickLocation;
    private Quaternion prevRotation;
    private Quaternion tickRotation;

    public Frame() {
        this(new com.jme3.math.Vector3f(), new Quaternion());
    }

    public Frame(com.jme3.math.Vector3f location, Quaternion rotation) {
        this.set(location, location, rotation, rotation);
    }

    public void set(com.jme3.math.Vector3f prevLocation, com.jme3.math.Vector3f tickLocation, Quaternion prevRotation, Quaternion tickRotation) {
        this.prevLocation = prevLocation;
        this.tickLocation = tickLocation;
        this.prevRotation = prevRotation;
        this.tickRotation = tickRotation;
    }

    public void from(Frame frame) {
        this.set(frame.prevLocation, frame.tickLocation, frame.prevRotation, frame.tickRotation);
    }

    public void from(Frame prevFrame, com.jme3.math.Vector3f tickLocation, Quaternion tickRotation) {
        this.set(prevFrame.tickLocation, tickLocation, prevFrame.tickRotation, tickRotation);
    }

    public com.jme3.math.Vector3f getLocation(com.jme3.math.Vector3f store, float tickDelta) {
        Vector3f prevLocation = Convert.toMinecraft(this.prevLocation);
        Vector3f tickLocation = Convert.toMinecraft(this.tickLocation);
        Vector3f lerp = VectorHelper.lerp((Vector3f)prevLocation, (Vector3f)tickLocation, (float)tickDelta);
        return store.set(Convert.toBullet(lerp));
    }

    public Quaternion getRotation(Quaternion store, float tickDelta) {
        Quaternionf prevRotation = Convert.toMinecraft(this.prevRotation);
        Quaternionf tickRotation = Convert.toMinecraft(this.tickRotation);
        Quaternionf slerp = QuaternionHelper.slerp((Quaternionf)prevRotation, (Quaternionf)tickRotation, (float)tickDelta);
        return store.set(Convert.toBullet(slerp));
    }

    public com.jme3.math.Vector3f getLocationDelta(com.jme3.math.Vector3f store) {
        store.set(this.tickLocation.subtract(this.prevLocation));
        return store;
    }

    public com.jme3.math.Vector3f getRotationDelta(com.jme3.math.Vector3f store) {
        Quaternionf tickRotation = Convert.toMinecraft(this.tickRotation);
        Quaternionf prevRotation = Convert.toMinecraft(this.prevRotation);
        Vector3f tickAngles = QuaternionHelper.toEulerAngles((Quaternionf)tickRotation);
        Vector3f prevAngles = QuaternionHelper.toEulerAngles((Quaternionf)prevRotation);
        tickAngles.sub((Vector3fc)prevAngles);
        store.set(Convert.toBullet(tickAngles));
        return store;
    }
}

