/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.mixin.common.entity;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.api.EntityPhysicsElement;
import dev.lazurite.rayon.impl.bullet.collision.body.EntityRigidBody;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.toolbox.api.math.QuaternionHelper;
import dev.lazurite.toolbox.api.math.VectorHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void pushAwayFrom(Entity entity, CallbackInfo info) {
        if (EntityPhysicsElement.is((Entity)this) && EntityPhysicsElement.is(entity)) {
            info.cancel();
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    public void move(CallbackInfo info) {
        if (EntityPhysicsElement.is((Entity)this)) {
            info.cancel();
        }
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    public void saveWithoutId(CompoundTag tag, CallbackInfoReturnable<CompoundTag> info) {
        if (EntityPhysicsElement.is((Entity)this)) {
            EntityRigidBody rigidBody = EntityPhysicsElement.get((Entity)this).getRigidBody();
            tag.m_128365_("orientation", (Tag)QuaternionHelper.toTag((Quaternionf)Convert.toMinecraft(rigidBody.getPhysicsRotation(new Quaternion()))));
            tag.m_128365_("linearVelocity", (Tag)VectorHelper.toTag((org.joml.Vector3f)Convert.toMinecraft(rigidBody.getLinearVelocity(new Vector3f()))));
            tag.m_128365_("angularVelocity", (Tag)VectorHelper.toTag((org.joml.Vector3f)Convert.toMinecraft(rigidBody.getAngularVelocity(new Vector3f()))));
            tag.m_128350_("mass", rigidBody.getMass());
            tag.m_128350_("dragCoefficient", rigidBody.getDragCoefficient());
            tag.m_128350_("friction", rigidBody.getFriction());
            tag.m_128350_("restitution", rigidBody.getRestitution());
            tag.m_128379_("terrainLoadingEnabled", rigidBody.terrainLoadingEnabled());
            tag.m_128405_("buoyancyType", rigidBody.getBuoyancyType().ordinal());
            tag.m_128405_("dragType", rigidBody.getDragType().ordinal());
        }
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    public void load(CompoundTag tag, CallbackInfo info) {
        if (EntityPhysicsElement.is((Entity)this)) {
            EntityPhysicsElement.get((Entity)this).getRigidBody().readTagInfo(tag);
        }
    }
}

