/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.event.network;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.impl.bullet.collision.body.EntityRigidBody;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.rayon.impl.event.ClientEventHandler;
import dev.lazurite.rayon.impl.event.ServerEventHandler;
import dev.lazurite.toolbox.api.math.QuaternionHelper;
import dev.lazurite.toolbox.api.math.VectorHelper;
import dev.lazurite.toolbox.api.network.ClientNetworking;
import dev.lazurite.toolbox.api.network.PacketRegistry;
import dev.lazurite.toolbox.api.network.ServerNetworking;
import dev.lazurite.toolbox.api.util.PlayerUtil;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;

public interface EntityNetworking {
    public static final ResourceLocation MOVEMENT = new ResourceLocation("rayon", "movement");
    public static final ResourceLocation PROPERTIES = new ResourceLocation("rayon", "properties");

    public static void register() {
        PacketRegistry.registerServerbound((ResourceLocation)MOVEMENT, ServerEventHandler::onMovementPacketReceived);
    }

    public static void registerClient() {
        PacketRegistry.registerClientbound((ResourceLocation)PROPERTIES, ClientEventHandler::onPropertiesPacketReceived);
        PacketRegistry.registerClientbound((ResourceLocation)MOVEMENT, ClientEventHandler::onMovementPacketReceived);
    }

    public static void sendMovement(EntityRigidBody rigidBody) {
        Consumer<FriendlyByteBuf> encoder = buf -> {
            buf.writeInt(((Entity)rigidBody.getElement().cast()).m_19879_());
            QuaternionHelper.toBuffer((FriendlyByteBuf)buf, (Quaternionf)Convert.toMinecraft(rigidBody.getPhysicsRotation(new Quaternion())));
            VectorHelper.toBuffer((FriendlyByteBuf)buf, (org.joml.Vector3f)Convert.toMinecraft(rigidBody.getPhysicsLocation(new Vector3f())));
            VectorHelper.toBuffer((FriendlyByteBuf)buf, (org.joml.Vector3f)Convert.toMinecraft(rigidBody.getLinearVelocity(new Vector3f())));
            VectorHelper.toBuffer((FriendlyByteBuf)buf, (org.joml.Vector3f)Convert.toMinecraft(rigidBody.getAngularVelocity(new Vector3f())));
        };
        if (rigidBody.getSpace().isServer()) {
            PlayerUtil.tracking((Entity)((Entity)rigidBody.getElement().cast())).forEach(player -> {
                if (!player.equals((Object)rigidBody.getPriorityPlayer())) {
                    ServerNetworking.send((ServerPlayer)player, (ResourceLocation)MOVEMENT, (Consumer)encoder);
                }
            });
        } else {
            ClientNetworking.send((ResourceLocation)MOVEMENT, encoder);
        }
    }

    public static void sendProperties(EntityRigidBody rigidBody) {
        Consumer<FriendlyByteBuf> encoder = buf -> {
            buf.writeInt(((Entity)rigidBody.getElement().cast()).m_19879_());
            buf.writeFloat(rigidBody.getMass());
            buf.writeFloat(rigidBody.getDragCoefficient());
            buf.writeFloat(rigidBody.getFriction());
            buf.writeFloat(rigidBody.getRestitution());
            buf.writeBoolean(rigidBody.terrainLoadingEnabled());
            buf.m_130068_((Enum)rigidBody.getBuoyancyType());
            buf.m_130068_((Enum)rigidBody.getDragType());
            buf.m_130077_(rigidBody.getPriorityPlayer() == null ? new UUID(0L, 0L) : rigidBody.getPriorityPlayer().m_20148_());
        };
        if (rigidBody.getSpace().isServer()) {
            PlayerUtil.tracking((Entity)((Entity)rigidBody.getElement().cast())).forEach(player -> ServerNetworking.send((ServerPlayer)player, (ResourceLocation)PROPERTIES, (Consumer)encoder));
        }
    }
}

