/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.event;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.api.EntityPhysicsElement;
import dev.lazurite.rayon.api.event.collision.PhysicsSpaceEvents;
import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.EntityRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.collision.space.generator.EntityCollisionGenerator;
import dev.lazurite.rayon.impl.bullet.collision.space.generator.PressureGenerator;
import dev.lazurite.rayon.impl.bullet.collision.space.generator.TerrainGenerator;
import dev.lazurite.rayon.impl.bullet.collision.space.storage.SpaceStorage;
import dev.lazurite.rayon.impl.bullet.collision.space.supplier.entity.ServerEntitySupplier;
import dev.lazurite.rayon.impl.bullet.collision.space.supplier.level.ServerLevelSupplier;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.rayon.impl.bullet.thread.PhysicsThread;
import dev.lazurite.rayon.impl.bullet.thread.util.ClientUtil;
import dev.lazurite.rayon.impl.event.network.EntityNetworking;
import dev.lazurite.toolbox.api.event.ServerEvents;
import dev.lazurite.toolbox.api.math.QuaternionHelper;
import dev.lazurite.toolbox.api.math.VectorHelper;
import dev.lazurite.toolbox.api.network.PacketRegistry;
import dev.lazurite.toolbox.api.util.PlayerUtil;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class ServerEventHandler {
    private static PhysicsThread thread;

    public static PhysicsThread getThread() {
        return thread;
    }

    public static void register() {
        PhysicsSpaceEvents.STEP.register(PressureGenerator::step);
        PhysicsSpaceEvents.STEP.register(TerrainGenerator::step);
        PhysicsSpaceEvents.ELEMENT_ADDED.register(ServerEventHandler::onElementAddedToSpace);
        ServerEvents.Lifecycle.LOAD_SERVER.register(ServerEventHandler::onServerStart);
        ServerEvents.Lifecycle.UNLOAD_SERVER.register(ServerEventHandler::onServerStop);
        ServerEvents.Tick.END_SERVER_TICK.register(ServerEventHandler::onServerTick);
        ServerEvents.Lifecycle.LOAD_LEVEL.register(ServerEventHandler::onLevelLoad);
        ServerEvents.Tick.START_LEVEL_TICK.register(ServerEventHandler::onStartLevelTick);
        ServerEvents.Tick.START_LEVEL_TICK.register(ServerEventHandler::onEntityStartLevelTick);
        ServerEvents.Block.BLOCK_UPDATE.register(ServerEventHandler::onBlockUpdate);
        ServerEvents.Entity.LOAD.register(ServerEventHandler::onEntityLoad);
        ServerEvents.Entity.START_TRACKING.register(ServerEventHandler::onStartTrackingEntity);
        ServerEvents.Entity.STOP_TRACKING.register(ServerEventHandler::onStopTrackingEntity);
    }

    public static void onBlockUpdate(Level level, BlockState blockState, BlockPos blockPos) {
        MinecraftSpace.getOptional(level).ifPresent(space -> space.doBlockUpdate(blockPos));
    }

    public static void onServerStart(MinecraftServer server) {
        thread = new PhysicsThread((Executor)server, Thread.currentThread(), new ServerLevelSupplier(server), new ServerEntitySupplier(), "Server Physics Thread");
    }

    public static void onServerStop(MinecraftServer server) {
        thread.destroy();
    }

    public static void onServerTick(MinecraftServer server) {
        if (ServerEventHandler.thread.throwable != null) {
            throw new RuntimeException(ServerEventHandler.thread.throwable);
        }
    }

    public static void onStartLevelTick(Level level) {
        if (!ClientUtil.isPaused()) {
            MinecraftSpace.get(level).step();
        }
    }

    public static void onLevelLoad(MinecraftServer server, ServerLevel level) {
        MinecraftSpace space = new MinecraftSpace(thread, (Level)level);
        ((SpaceStorage)level).setSpace(space);
        PhysicsSpaceEvents.INIT.invoke(new Object[]{space});
    }

    public static void onElementAddedToSpace(MinecraftSpace space, ElementRigidBody rigidBody) {
        if (rigidBody instanceof EntityRigidBody) {
            EntityRigidBody entityBody = (EntityRigidBody)rigidBody;
            Vec3 pos = ((Entity)entityBody.getElement().cast()).m_20182_();
            entityBody.setPhysicsLocation(Convert.toBullet(pos));
        }
    }

    public static void onEntityLoad(Entity entity) {
        if (EntityPhysicsElement.is(entity) && !PlayerUtil.tracking((Entity)entity).isEmpty()) {
            MinecraftSpace space = MinecraftSpace.get(entity.m_9236_());
            space.getWorkerThread().execute(() -> space.addCollisionObject(EntityPhysicsElement.get(entity).getRigidBody()));
        }
    }

    public static void onStartTrackingEntity(Entity entity, ServerPlayer player) {
        if (EntityPhysicsElement.is(entity)) {
            MinecraftSpace space = MinecraftSpace.get(entity.m_9236_());
            space.getWorkerThread().execute(() -> space.addCollisionObject(EntityPhysicsElement.get(entity).getRigidBody()));
        }
    }

    public static void onStopTrackingEntity(Entity entity, ServerPlayer player) {
        if (EntityPhysicsElement.is(entity) && PlayerUtil.tracking((Entity)entity).isEmpty()) {
            MinecraftSpace space = MinecraftSpace.get(entity.m_9236_());
            space.getWorkerThread().execute(() -> space.removeCollisionObject(EntityPhysicsElement.get(entity).getRigidBody()));
        }
    }

    public static void onEntityStartLevelTick(Level level) {
        MinecraftSpace space = MinecraftSpace.get(level);
        EntityCollisionGenerator.step(space);
        for (EntityRigidBody rigidBody : space.getRigidBodiesByClass(EntityRigidBody.class)) {
            if (rigidBody.isActive()) {
                if (rigidBody.isPositionDirty()) {
                    EntityNetworking.sendMovement(rigidBody);
                }
                if (rigidBody.arePropertiesDirty()) {
                    EntityNetworking.sendProperties(rigidBody);
                }
            }
            Vector3f location = rigidBody.getFrame().getLocation(new Vector3f(), 1.0f);
            ((Entity)rigidBody.getElement().cast()).m_20248_((double)location.x, (double)location.y, (double)location.z);
        }
    }

    public static void onMovementPacketReceived(PacketRegistry.ServerboundContext context) {
        EntityRigidBody rigidBody;
        FriendlyByteBuf buf = context.byteBuf();
        int entityId = buf.readInt();
        Quaternion rotation = Convert.toBullet(QuaternionHelper.fromBuffer((FriendlyByteBuf)buf));
        Vector3f location = Convert.toBullet(VectorHelper.fromBuffer((FriendlyByteBuf)buf));
        Vector3f linearVelocity = Convert.toBullet(VectorHelper.fromBuffer((FriendlyByteBuf)buf));
        Vector3f angularVelocity = Convert.toBullet(VectorHelper.fromBuffer((FriendlyByteBuf)buf));
        ServerPlayer player = context.player();
        Level level = player.m_9236_();
        Entity entity = level.m_6815_(entityId);
        if (EntityPhysicsElement.is(entity) && player.equals((Object)(rigidBody = EntityPhysicsElement.get(entity).getRigidBody()).getPriorityPlayer())) {
            PhysicsThread.get(level).execute(() -> {
                rigidBody.setPhysicsRotation(rotation);
                rigidBody.setPhysicsLocation(location);
                rigidBody.setLinearVelocity(linearVelocity);
                rigidBody.setAngularVelocity(angularVelocity);
                rigidBody.activate();
            });
        }
    }
}

