/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.event;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.lazurite.rayon.api.EntityPhysicsElement;
import dev.lazurite.rayon.api.event.collision.PhysicsSpaceEvents;
import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.EntityRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.collision.space.generator.EntityCollisionGenerator;
import dev.lazurite.rayon.impl.bullet.collision.space.storage.SpaceStorage;
import dev.lazurite.rayon.impl.bullet.collision.space.supplier.entity.ClientEntitySupplier;
import dev.lazurite.rayon.impl.bullet.collision.space.supplier.level.ClientLevelSupplier;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.rayon.impl.bullet.thread.PhysicsThread;
import dev.lazurite.rayon.impl.bullet.thread.util.ClientUtil;
import dev.lazurite.rayon.impl.event.network.EntityNetworking;
import dev.lazurite.rayon.impl.util.debug.CollisionObjectDebugger;
import dev.lazurite.toolbox.api.event.ClientEvents;
import dev.lazurite.toolbox.api.math.QuaternionHelper;
import dev.lazurite.toolbox.api.math.VectorHelper;
import dev.lazurite.toolbox.api.network.PacketRegistry;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public final class ClientEventHandler {
    private static PhysicsThread thread;

    public static PhysicsThread getThread() {
        return thread;
    }

    public static void register() {
        ClientEvents.Lifecycle.PRE_LOGIN.register(ClientEventHandler::onGameJoin);
        ClientEvents.Lifecycle.DISCONNECT.register(ClientEventHandler::onDisconnect);
        ClientEvents.Tick.END_CLIENT_TICK.register(ClientEventHandler::onClientTick);
        ClientEvents.Lifecycle.LOAD_LEVEL.register(ClientEventHandler::onLevelLoad);
        ClientEvents.Tick.END_LEVEL_TICK.register(ClientEventHandler::onStartLevelTick);
        ClientEvents.Tick.END_LEVEL_TICK.register(ClientEventHandler::onEntityStartLevelTick);
        ClientEvents.Render.BEFORE_DEBUG.register((poseStack, camera, level, tickDelta) -> ClientEventHandler.onDebugRender((Level)level, poseStack, tickDelta));
        ClientEvents.Entity.LOAD.register(ClientEventHandler::onEntityLoad);
        ClientEvents.Entity.UNLOAD.register(ClientEventHandler::onEntityUnload);
    }

    public static void onStartLevelTick(Level level) {
        if (!ClientUtil.isPaused()) {
            MinecraftSpace.get(level).step();
        }
    }

    public static void onLevelLoad(Minecraft minecraft, ClientLevel level) {
        MinecraftSpace space = new MinecraftSpace(thread, (Level)level);
        ((SpaceStorage)level).setSpace(space);
        PhysicsSpaceEvents.INIT.invoke(new Object[]{space});
    }

    public static void onClientTick(Minecraft minecraft) {
        if (thread != null && ClientEventHandler.thread.throwable != null) {
            throw new RuntimeException(ClientEventHandler.thread.throwable);
        }
    }

    public static void onGameJoin(Minecraft minecraft) {
        ClientLevelSupplier supplier = new ClientLevelSupplier(minecraft);
        thread = new PhysicsThread((Executor)minecraft, Thread.currentThread(), supplier, new ClientEntitySupplier(), "Client Physics Thread");
    }

    public static void onDisconnect(Minecraft minecraft, ClientLevel level) {
        thread.destroy();
    }

    public static void onDebugRender(Level level, PoseStack stack, float tickDelta) {
        if (CollisionObjectDebugger.isEnabled()) {
            CollisionObjectDebugger.renderSpace(MinecraftSpace.get(level), stack, tickDelta);
        }
    }

    public static void onEntityLoad(Entity entity) {
        if (EntityPhysicsElement.is(entity)) {
            Level level = entity.m_9236_();
            PhysicsThread.get(level).execute(() -> MinecraftSpace.getOptional(level).ifPresent(space -> space.addCollisionObject(EntityPhysicsElement.get(entity).getRigidBody())));
        }
    }

    public static void onEntityUnload(Entity entity) {
        if (EntityPhysicsElement.is(entity)) {
            Level level = entity.m_9236_();
            PhysicsThread.get(level).execute(() -> MinecraftSpace.getOptional(level).ifPresent(space -> space.removeCollisionObject(EntityPhysicsElement.get(entity).getRigidBody())));
        }
    }

    public static void onEntityStartLevelTick(Level level) {
        MinecraftSpace space = MinecraftSpace.get(level);
        EntityCollisionGenerator.step(space);
        for (EntityRigidBody rigidBody : space.getRigidBodiesByClass(EntityRigidBody.class)) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (rigidBody.isActive() && rigidBody.isPositionDirty() && player != null && player.equals((Object)rigidBody.getPriorityPlayer())) {
                EntityNetworking.sendMovement(rigidBody);
            }
            Vector3f location = rigidBody.getFrame().getLocation(new Vector3f(), 1.0f);
            ((Entity)rigidBody.getElement().cast()).m_20248_((double)location.x, (double)location.y, (double)location.z);
        }
    }

    public static void onMovementPacketReceived(PacketRegistry.ClientboundContext context) {
        Entity entity;
        FriendlyByteBuf buf = context.byteBuf();
        int entityId = buf.readInt();
        Quaternion rotation = Convert.toBullet(QuaternionHelper.fromBuffer((FriendlyByteBuf)buf));
        Vector3f location = Convert.toBullet(VectorHelper.fromBuffer((FriendlyByteBuf)buf));
        Vector3f linearVelocity = Convert.toBullet(VectorHelper.fromBuffer((FriendlyByteBuf)buf));
        Vector3f angularVelocity = Convert.toBullet(VectorHelper.fromBuffer((FriendlyByteBuf)buf));
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && EntityPhysicsElement.is(entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId))) {
            EntityRigidBody rigidBody = EntityPhysicsElement.get(entity).getRigidBody();
            PhysicsThread.get((Level)level).execute(() -> {
                rigidBody.setPhysicsRotation(rotation);
                rigidBody.setPhysicsLocation(location);
                rigidBody.setLinearVelocity(linearVelocity);
                rigidBody.setAngularVelocity(angularVelocity);
                rigidBody.activate();
            });
        }
    }

    public static void onPropertiesPacketReceived(PacketRegistry.ClientboundContext context) {
        Entity entity;
        FriendlyByteBuf buf = context.byteBuf();
        int entityId = buf.readInt();
        float mass = buf.readFloat();
        float dragCoefficient = buf.readFloat();
        float friction = buf.readFloat();
        float restitution = buf.readFloat();
        boolean terrainLoading = buf.readBoolean();
        ElementRigidBody.BuoyancyType buoyancyType = (ElementRigidBody.BuoyancyType)buf.m_130066_(ElementRigidBody.BuoyancyType.class);
        ElementRigidBody.DragType dragType = (ElementRigidBody.DragType)buf.m_130066_(ElementRigidBody.DragType.class);
        UUID priorityPlayer = buf.m_130259_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && EntityPhysicsElement.is(entity = level.m_6815_(entityId))) {
            EntityRigidBody rigidBody = EntityPhysicsElement.get(entity).getRigidBody();
            PhysicsThread.get((Level)level).execute(() -> {
                rigidBody.setMass(mass);
                rigidBody.setDragCoefficient(dragCoefficient);
                rigidBody.setFriction(friction);
                rigidBody.setRestitution(restitution);
                rigidBody.setTerrainLoadingEnabled(terrainLoading);
                rigidBody.setBuoyancyType(buoyancyType);
                rigidBody.setDragType(dragType);
                rigidBody.prioritize(rigidBody.getSpace().getLevel().m_46003_(priorityPlayer));
                rigidBody.activate();
            });
        }
    }
}

