/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.thread;

import dev.lazurite.rayon.impl.Rayon;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.collision.space.supplier.entity.EntitySupplier;
import dev.lazurite.rayon.impl.bullet.collision.space.supplier.level.LevelSupplier;
import dev.lazurite.rayon.impl.bullet.thread.util.ClientUtil;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PhysicsThread
extends Thread
implements Executor {
    private final Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();
    private final Executor parentExecutor;
    private final Thread parentThread;
    private final LevelSupplier levelSupplier;
    private final EntitySupplier entitySupplier;
    public volatile Throwable throwable;
    public volatile boolean running = true;

    public static Optional<PhysicsThread> getOptional(ReentrantBlockableEventLoop<? extends Runnable> executor) {
        return Optional.ofNullable(PhysicsThread.get(executor));
    }

    public static PhysicsThread get(ReentrantBlockableEventLoop<? extends Runnable> executor) {
        return Rayon.getThread(!(executor instanceof MinecraftServer));
    }

    public static PhysicsThread get(Level level) {
        return MinecraftSpace.get(level).getWorkerThread();
    }

    public PhysicsThread(Executor parentExecutor, Thread parentThread, LevelSupplier levelSupplier, EntitySupplier entitySupplier, String name) {
        this.parentExecutor = parentExecutor;
        this.parentThread = parentThread;
        this.levelSupplier = levelSupplier;
        this.entitySupplier = entitySupplier;
        this.setName(name);
        this.setUncaughtExceptionHandler((thread, throwable) -> {
            this.running = false;
            this.throwable = throwable;
        });
        Rayon.LOGGER.info("Starting " + this.getName());
        this.start();
    }

    @Override
    public void run() {
        while (this.running) {
            if (ClientUtil.isPaused()) continue;
            while (!this.tasks.isEmpty()) {
                this.tasks.poll().run();
            }
        }
    }

    @Override
    public void execute(@NotNull Runnable task) {
        this.tasks.add(task);
    }

    public LevelSupplier getLevelSupplier() {
        return this.levelSupplier;
    }

    public EntitySupplier getEntitySupplier() {
        return this.entitySupplier;
    }

    public Executor getParentExecutor() {
        return this.parentExecutor;
    }

    public Thread getParentThread() {
        return this.parentThread;
    }

    public void destroy() {
        this.running = false;
        Rayon.LOGGER.info("Stopping " + this.getName());
        try {
            this.join(5000L);
        }
        catch (InterruptedException e) {
            Rayon.LOGGER.error("Error joining " + this.getName());
            e.printStackTrace();
        }
    }
}

