/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.natives;

import com.jme3.system.JmeSystem;
import com.jme3.system.NativeLibraryLoader;
import com.jme3.system.Platform;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.lazurite.rayon.impl.Rayon;
import dev.lazurite.rayon.impl.bullet.natives.forge.NativeLoaderImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;

public class NativeLoader {
    public static void load() {
        String fileName = NativeLoader.getPlatformSpecificName();
        Path nativesFolder = NativeLoader.getGameDir().resolve("natives/");
        URL url = NativeLoader.class.getResource("/assets/natives/" + fileName);
        try {
            if (!Files.exists(nativesFolder, new LinkOption[0])) {
                Files.createDirectory(nativesFolder, new FileAttribute[0]);
            }
            Path destination = nativesFolder.resolve(fileName);
            File destinationFile = destination.toFile();
            if (Files.exists(destination, new LinkOption[0]) && !destinationFile.delete()) {
                Rayon.LOGGER.warn("Failed to remove old bullet natives.");
            }
            try {
                FileUtils.copyURLToFile((URL)url, (File)destinationFile);
            }
            catch (IOException e) {
                Rayon.LOGGER.warn("Unable to copy natives.");
            }
            NativeLibraryLoader.loadLibbulletjme(true, nativesFolder.toFile(), "Release", "Sp");
        }
        catch (IOException | NoSuchElementException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to load bullet natives.");
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    static Path getGameDir() {
        return NativeLoaderImpl.getGameDir();
    }

    static String getPlatformSpecificName() {
        Platform platform = JmeSystem.getPlatform();
        String name = switch (platform) {
            case Platform.Windows32, Platform.Windows64 -> "bulletjme.dll";
            case Platform.Android_ARM7, Platform.Android_ARM8, Platform.Linux_ARM32, Platform.Linux_ARM64, Platform.Linux32, Platform.Linux64 -> "libbulletjme.so";
            case Platform.MacOSX32, Platform.MacOSX64, Platform.MacOSX_ARM64 -> "libbulletjme.dylib";
            default -> throw new RuntimeException("Invalid platform " + platform);
        };
        return platform + "ReleaseSp_" + name;
    }
}

