/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.space.generator;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.TerrainRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.collision.space.cache.ChunkCache;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class TerrainGenerator {
    public static void step(MinecraftSpace space) {
        ChunkCache chunkCache = space.getChunkCache();
        HashSet keep = new HashSet();
        for (ElementRigidBody rigidBody : space.getRigidBodiesByClass(ElementRigidBody.class)) {
            if (!rigidBody.terrainLoadingEnabled() || !rigidBody.isActive()) continue;
            AABB aabb = rigidBody.getCurrentMinecraftBoundingBox().m_82400_(0.5);
            BlockPos.m_121921_((AABB)aabb).forEach(blockPos -> chunkCache.getBlockData((BlockPos)blockPos).ifPresent(blockData -> space.getTerrainObjectAt((BlockPos)blockPos).ifPresentOrElse(terrain -> {
                if (blockData.blockState() != terrain.getBlockState()) {
                    space.removeCollisionObject((PhysicsCollisionObject)terrain);
                    TerrainRigidBody terrain2 = TerrainRigidBody.from(blockData);
                    space.addCollisionObject(terrain2);
                    keep.add(terrain2);
                } else {
                    keep.add(terrain);
                }
            }, () -> {
                TerrainRigidBody terrain = TerrainRigidBody.from(blockData);
                space.addCollisionObject(terrain);
                keep.add(terrain);
            })));
        }
        space.getTerrainMap().forEach((blockPos, terrain) -> {
            if (!keep.contains(terrain)) {
                space.removeTerrainObjectAt((BlockPos)blockPos);
            }
        });
    }
}

