/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.space.generator;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.shape.Triangle;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.collision.space.cache.ChunkCache;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;

public class PressureGenerator {
    public static final float STOPPING_TIME = 2.0f;
    public static final float WATER_DENSITY = 1000.0f;
    public static final float AIR_DENSITY = 1.225f;
    public static final float GAS_CONSTANT = 8.31446f;
    public static final float MOLAR_MASS_OF_AIR = 0.0289644f;
    public static final float SEA_LEVEL_PRESSURE = 101325.0f;
    public static final float TEMPERATURE = 300.0f;
    public static final int SEA_LEVEL = 62;

    public static void step(MinecraftSpace space) {
        ChunkCache chunkCache = space.getChunkCache();
        float timeStep = space.getAccuracy();
        Vector3f gravity = space.getGravity(new Vector3f());
        Vector3f location = new Vector3f();
        Vector3f linearVelocity = new Vector3f();
        Vector3f angularVelocity = new Vector3f();
        Quaternion rotation = new Quaternion();
        for (ElementRigidBody rigidBody : space.getRigidBodiesByClass(ElementRigidBody.class)) {
            BlockPos blockPos;
            if (!rigidBody.isActive() || rigidBody.getBuoyancyType() == ElementRigidBody.BuoyancyType.NONE && rigidBody.getDragType() == ElementRigidBody.DragType.NONE) {
                rigidBody.getSleepTimer().reset();
                continue;
            }
            rigidBody.getPhysicsLocation(location);
            rigidBody.getLinearVelocity(linearVelocity);
            rigidBody.getAngularVelocity(angularVelocity);
            rigidBody.getPhysicsRotation(rotation);
            if (linearVelocity.length() < rigidBody.getLinearSleepingThreshold() && angularVelocity.length() < rigidBody.getAngularSleepingThreshold()) {
                if (rigidBody.getSleepTimer().get() > 2.0f) {
                    rigidBody.setDeactivationTime(2.0f);
                    continue;
                }
            } else {
                rigidBody.getSleepTimer().reset();
            }
            float mass = rigidBody.getMass();
            float density = mass / rigidBody.getMinecraftShape().getVolume();
            float dragCoefficient = rigidBody.getDragCoefficient();
            List<Triangle> triangles = rigidBody.getMinecraftShape().getTriangles(rotation);
            HashMap<Triangle, Float> crossSectionalAreas = new HashMap<Triangle, Float>();
            ArrayList<Triangle> submergedTriangles = new ArrayList<Triangle>();
            float totalCrossSectionalArea = 0.0f;
            for (Triangle triangle : triangles) {
                Vector3f centroid = triangle.getCentroid();
                Vector3f area = triangle.getArea();
                Vector3f tangentialVelocity = new Vector3f(angularVelocity).cross(centroid);
                Vector3f netVelocity = new Vector3f(tangentialVelocity).addLocal(linearVelocity);
                if (Math.signum(netVelocity.dot(area)) == 1.0f) {
                    float crossSectionalArea = netVelocity.normalize().dot(area);
                    crossSectionalAreas.put(triangle, Float.valueOf(crossSectionalArea));
                    totalCrossSectionalArea += crossSectionalArea;
                }
                blockPos = new BlockPos((int)(location.x + centroid.x), (int)(location.y + centroid.y), (int)(location.z + centroid.z));
                Vector3f posRelativeToBlockCenter = new Vector3f(centroid).add(location).subtract(Convert.toBullet(blockPos));
                chunkCache.getFluidColumn(blockPos).ifPresent(fluidColumn -> {
                    float waterHeight = (float)fluidColumn.getTop().blockPos().m_123342_() + fluidColumn.getTopHeight(posRelativeToBlockCenter) - location.y - centroid.y;
                    if (waterHeight > 0.0f) {
                        submergedTriangles.add(triangle);
                    }
                });
            }
            float totalArea = totalCrossSectionalArea;
            float addedMassAdjustment = density < 50.0f ? PressureGenerator.getAddedMassForceAdjustment(submergedTriangles, mass) : 1.0f;
            for (Triangle triangle : triangles) {
                Vector3f centroid = triangle.getCentroid();
                Vector3f area = triangle.getArea();
                blockPos = new BlockPos((int)(location.x + centroid.x), (int)(location.y + centroid.y), (int)(location.z + centroid.z));
                if (submergedTriangles.contains(triangle)) {
                    Vector3f tangentialVelocity;
                    Vector3f netVelocity;
                    float pressure;
                    Vector3f buoyantForce;
                    Vector3f posRelativeToBlockCenter = new Vector3f(centroid).add(location).subtract(Convert.toBullet(blockPos));
                    Float waterHeight = chunkCache.getFluidColumn(blockPos).map(fluidColumn -> Float.valueOf((float)fluidColumn.getTop().blockPos().m_123342_() + fluidColumn.getTopHeight(posRelativeToBlockCenter) - location.y - centroid.y)).orElse(Float.valueOf(0.0f));
                    chunkCache.getFluidColumn(new BlockPos((int)location.x, (int)location.y, (int)location.z)).ifPresent(fluidColumn -> {
                        Vector3f flowForce = new Vector3f(fluidColumn.getFlow());
                        if (Float.isFinite(flowForce.lengthSquared()) && flowForce.lengthSquared() > 0.0f) {
                            rigidBody.applyForce(flowForce, centroid);
                        }
                    });
                    if (rigidBody.isWaterBuoyancyEnabled() && Float.isFinite((buoyantForce = new Vector3f(area).multLocal(pressure = gravity.y * 1000.0f * waterHeight.floatValue())).lengthSquared()) && buoyantForce.lengthSquared() > 0.0f) {
                        rigidBody.applyForce(buoyantForce.multLocal(addedMassAdjustment), centroid);
                    }
                    if (!rigidBody.isWaterDragEnabled() || Math.signum((netVelocity = new Vector3f(tangentialVelocity = new Vector3f(angularVelocity).cross(centroid)).addLocal(linearVelocity)).dot(area)) != 1.0f) continue;
                    Vector3f dragForce = new Vector3f(area).multLocal(-0.5f * dragCoefficient * 1000.0f * netVelocity.lengthSquared());
                    dragForce.multLocal(-1.0f * Math.signum(netVelocity.dot(dragForce)));
                    Vector3f stoppingForce = new Vector3f(netVelocity).multLocal(-1.0f * rigidBody.getMass() * ((Float)crossSectionalAreas.get(triangle)).floatValue() / totalArea).divideLocal(timeStep);
                    if (dragForce.length() < stoppingForce.length()) {
                        rigidBody.applyForce(dragForce.multLocal(addedMassAdjustment), centroid);
                        continue;
                    }
                    rigidBody.applyForce(stoppingForce.divideLocal(2.0f), centroid);
                    continue;
                }
                if (!rigidBody.isAirDragEnabled()) continue;
                float airDensity = (float)((double)1.225f * Math.exp(0.0289644f * gravity.y * (62.0f - location.y - centroid.y) / 2494.338f));
                Vector3f tangentialVelocity = new Vector3f(angularVelocity).cross(centroid);
                Vector3f netVelocity = new Vector3f(tangentialVelocity).addLocal(linearVelocity);
                if (Math.signum(netVelocity.dot(area)) != 1.0f) continue;
                Vector3f dragForce = new Vector3f(area).multLocal(-0.5f * dragCoefficient * airDensity * netVelocity.lengthSquared());
                dragForce.multLocal(-1.0f * Math.signum(netVelocity.dot(dragForce)));
                if (!Float.isFinite(dragForce.lengthSquared()) || !(dragForce.lengthSquared() > 0.0f)) continue;
                rigidBody.applyForce(dragForce, centroid);
            }
            if (rigidBody.getDragType() != ElementRigidBody.DragType.SIMPLE) continue;
            BoundingBox box = rigidBody.getCollisionShape().boundingBox(new Vector3f(), new Quaternion(), new BoundingBox());
            float area = box.getExtent(new Vector3f()).lengthSquared();
            Vector3f dragForce = new Vector3f(linearVelocity.normalize()).multLocal(-0.5f * area * dragCoefficient * 1.225f * linearVelocity.lengthSquared());
            if (!Float.isFinite(dragForce.lengthSquared()) || !(dragForce.lengthSquared() > 0.0f)) continue;
            rigidBody.applyCentralForce(dragForce);
        }
    }

    public static float getAddedMassForceAdjustment(List<Triangle> triangles, float mass) {
        int n = triangles.size();
        double sum = triangles.stream().mapToDouble(triangle -> triangle.getArea().length() * triangle.getCentroid().length()).sum();
        double addedMass = (double)(1000.0f / (float)(6 * n)) * sum;
        return (float)((double)mass / ((double)mass + addedMass));
    }
}

