/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.space.generator;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.impl.bullet.collision.body.EntityRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;

public class EntityCollisionGenerator {
    public static void step(MinecraftSpace space) {
        for (EntityRigidBody rigidBody : space.getRigidBodiesByClass(EntityRigidBody.class)) {
            if (rigidBody.getElement().skipVanillaEntityCollisions()) continue;
            BoundingBox box = rigidBody.getCurrentBoundingBox();
            Vector3f location = rigidBody.getPhysicsLocation(new Vector3f()).subtract(new Vector3f(0.0f, -box.getYExtent(), 0.0f));
            float mass = rigidBody.getMass();
            AABB vanillaBox = rigidBody.getCurrentMinecraftBoundingBox();
            for (Entity entity : space.getWorkerThread().getEntitySupplier().getInsideOf(rigidBody, vanillaBox)) {
                Vector3f entityPos = Convert.toBullet(entity.m_20182_().m_82520_(0.0, entity.m_20191_().m_82376_(), 0.0));
                Vector3f normal = location.subtract(entityPos).multLocal(new Vector3f(1.0f, 0.0f, 1.0f)).normalize();
                AABB intersection = entity.m_20191_().m_82323_(vanillaBox);
                Vector3f force = normal.clone().multLocal((float)intersection.m_82309_() / (float)vanillaBox.m_82309_()).multLocal(mass).multLocal(new Vector3f(1.0f, 0.0f, 1.0f));
                rigidBody.applyCentralImpulse(force);
            }
        }
    }
}

