/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.space.cache;

import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.collision.space.cache.ChunkCache;
import dev.lazurite.rayon.impl.bullet.collision.space.cache.ShapeCache;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SimpleChunkCache
implements ChunkCache {
    private static final Hash.Strategy<BlockPos> QUICK_BLOCK_POS = new Hash.Strategy<BlockPos>(){

        public int hashCode(BlockPos pos) {
            return pos.hashCode();
        }

        public boolean equals(BlockPos pos, BlockPos k1) {
            return k1 != null && pos.m_123341_() == k1.m_123341_() && pos.m_123342_() == k1.m_123342_() && pos.m_123343_() == k1.m_123343_();
        }
    };
    private final MinecraftSpace space;
    private final Map<BlockPos, ChunkCache.BlockData> blockData;
    private final List<ChunkCache.FluidColumn> fluidColumns;
    private final Long2ObjectMap<List<ChunkCache.FluidColumn>> fluidColumnByIndex;
    private final LongSet activePositions;
    private final Long2ObjectMap<List<BlockPos>> activeColumn;

    SimpleChunkCache(MinecraftSpace space) {
        this.space = space;
        this.blockData = new ConcurrentHashMap<BlockPos, ChunkCache.BlockData>();
        this.fluidColumns = new ArrayList<ChunkCache.FluidColumn>();
        this.activePositions = new LongOpenHashSet();
        this.activeColumn = new Long2ObjectOpenHashMap(65536);
        this.fluidColumnByIndex = new Long2ObjectOpenHashMap(65536);
    }

    @Override
    public void loadFluidData(BlockPos blockPos) {
        List columns;
        Level level = this.space.getLevel();
        if (!level.m_6425_(blockPos).m_76178_() && ((columns = (List)this.fluidColumnByIndex.get(SimpleChunkCache.columnIndex(blockPos))) == null || columns.stream().noneMatch(column -> column.contains(blockPos)))) {
            ChunkCache.FluidColumn column2 = new ChunkCache.FluidColumn(new BlockPos((Vec3i)blockPos), level);
            this.fluidColumns.add(column2);
            ((List)this.fluidColumnByIndex.computeIfAbsent(column2.getIndex(), a -> new ArrayList())).add(column2);
        }
    }

    @Override
    public void loadBlockData(BlockPos blockPos) {
        Level level = this.space.getLevel();
        BlockState blockState = level.m_8055_(blockPos);
        this.loadBlockData(blockPos.m_7949_(), level, blockState);
    }

    private void loadBlockData(BlockPos blockPos, Level level, BlockState blockState) {
        if (ChunkCache.isValidBlock(blockState)) {
            this.blockData.put(blockPos, new ChunkCache.BlockData(level, blockPos, blockState, ShapeCache.getShapeFor(blockState, level, blockPos)));
        } else {
            this.blockData.remove(blockPos);
        }
    }

    @Override
    public void refreshAll() {
        Level level = this.space.getLevel();
        this.activePositions.clear();
        this.activeColumn.clear();
        for (ElementRigidBody rigidBody : this.space.getRigidBodiesByClass(ElementRigidBody.class)) {
            if (!rigidBody.terrainLoadingEnabled() || !rigidBody.isActive()) continue;
            AABB aabb = rigidBody.getCurrentMinecraftBoundingBox().m_82400_((double)(1.0f + Mth.m_14116_((float)rigidBody.getSquaredSpeed()) / 20.0f));
            BlockPos.m_121921_((AABB)aabb).forEach(blockPos -> {
                if (this.activePositions.contains(blockPos.m_121878_())) {
                    return;
                }
                BlockPos pos = blockPos.m_7949_();
                ((List)this.activeColumn.computeIfAbsent(SimpleChunkCache.columnIndex(pos), a -> new ObjectArrayList(512))).add(pos);
                this.activePositions.add(pos.m_121878_());
                ChunkCache.BlockData blockData = this.blockData.get(pos);
                BlockState blockState = level.m_8055_(pos);
                if (blockData != null) {
                    if (blockData.blockState() != blockState) {
                        this.loadBlockData(pos, level, blockState);
                    }
                } else {
                    this.loadBlockData(pos, level, blockState);
                }
                if (this.getFluidColumn(pos).isEmpty()) {
                    this.loadFluidData(pos);
                }
            });
        }
        this.blockData.keySet().removeIf(blockPos -> !this.activePositions.contains(blockPos.m_121878_()));
        this.fluidColumns.removeIf(column -> {
            List y;
            boolean x;
            boolean bl = x = !this.isInActiveColumn((ChunkCache.FluidColumn)column);
            if (x && (y = (List)this.fluidColumnByIndex.get(column.getIndex())) != null) {
                y.remove(column);
            }
            return x;
        });
    }

    private static long columnIndex(BlockPos blockPos) {
        return Integer.toUnsignedLong(blockPos.m_123341_()) << 32 | Integer.toUnsignedLong(blockPos.m_123343_());
    }

    private boolean isInActiveColumn(ChunkCache.FluidColumn column) {
        List list = (List)this.activeColumn.get(column.getIndex());
        if (list == null) {
            return false;
        }
        for (BlockPos e : list) {
            if (!column.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MinecraftSpace getSpace() {
        return this.space;
    }

    @Override
    public List<ChunkCache.BlockData> getBlockData() {
        return new ArrayList<ChunkCache.BlockData>(this.blockData.values());
    }

    @Override
    public List<ChunkCache.FluidColumn> getFluidColumns() {
        return new ArrayList<ChunkCache.FluidColumn>(this.fluidColumns);
    }

    @Override
    public Optional<ChunkCache.BlockData> getBlockData(BlockPos blockPos) {
        return Optional.ofNullable(this.blockData.get(blockPos));
    }

    @Override
    public Optional<ChunkCache.FluidColumn> getFluidColumn(BlockPos blockPos) {
        List allColumns = (List)this.fluidColumnByIndex.get(SimpleChunkCache.columnIndex(blockPos));
        if (allColumns != null) {
            for (ChunkCache.FluidColumn column : allColumns) {
                if (!column.contains(blockPos)) continue;
                return Optional.of(column);
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isActive(BlockPos blockPos) {
        return this.activePositions.contains(blockPos.m_121878_());
    }
}

