/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.space.cache;

import dev.lazurite.rayon.impl.bullet.collision.body.shape.MinecraftShape;
import dev.lazurite.rayon.impl.bullet.collision.space.block.BlockProperty;
import dev.lazurite.rayon.impl.bullet.collision.space.cache.ChunkCache;
import dev.lazurite.transporter.api.pattern.Pattern;
import dev.lazurite.transporter.impl.Transporter;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class ShapeCache {
    private static final MinecraftShape FALLBACK_SHAPE = MinecraftShape.convex(new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5));
    private static final IdentityHashMap<BlockState, MinecraftShape> SHAPES_SERVER = new IdentityHashMap();
    private static final IdentityHashMap<BlockState, MinecraftShape> SHAPES_CLIENT = new IdentityHashMap();

    public static MinecraftShape getShapeFor(BlockState blockState, Level level, BlockPos blockPos) {
        if (blockState.m_60734_().m_49967_()) {
            return ShapeCache.createShapeFor(blockState, level, blockPos);
        }
        Map<BlockState, MinecraftShape> shapes = ShapeCache.getShapes(level.f_46443_);
        MinecraftShape shape = shapes.get(blockState);
        if (shape == null) {
            shape = ShapeCache.createShapeFor(blockState, level, BlockPos.f_121853_);
            shapes.put(blockState, shape);
        }
        return shape;
    }

    private static Map<BlockState, MinecraftShape> getShapes(boolean isClientSide) {
        return isClientSide ? SHAPES_CLIENT : SHAPES_SERVER;
    }

    @Nullable
    private static MinecraftShape createShapeFor(BlockState blockState, Level level, BlockPos blockPos) {
        Pattern pattern;
        BlockProperty properties = BlockProperty.getBlockProperty(blockState.m_60734_());
        MinecraftShape shape = null;
        if (!(blockState.m_60838_((BlockGetter)level, blockPos) && (properties == null || properties.isFullBlock()) || (pattern = level.f_46443_ ? ChunkCache.genShapeForBlock((BlockGetter)level, blockPos, blockState) : Transporter.getPatternBuffer().getBlock(Block.m_49956_((BlockState)blockState))) == null || pattern.getQuads().isEmpty())) {
            shape = MinecraftShape.concave(pattern);
        }
        if (shape == null) {
            VoxelShape voxelShape = blockState.m_60812_((BlockGetter)level, blockPos);
            shape = !voxelShape.m_83281_() ? MinecraftShape.convex(voxelShape) : FALLBACK_SHAPE;
        }
        return shape;
    }
}

