/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.space.cache;

import com.jme3.math.Vector3f;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.lazurite.rayon.impl.bullet.collision.body.shape.MinecraftShape;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.collision.space.block.BlockProperty;
import dev.lazurite.rayon.impl.bullet.collision.space.cache.SimpleChunkCache;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.transporter.api.Disassembler;
import dev.lazurite.transporter.api.pattern.Pattern;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public interface ChunkCache {
    public static ChunkCache create(MinecraftSpace space) {
        return new SimpleChunkCache(space);
    }

    public static boolean isValidBlock(BlockState blockState) {
        if (blockState == null) {
            return false;
        }
        Block block = blockState.m_60734_();
        BlockProperty properties = BlockProperty.getBlockProperty(block);
        return properties != null ? properties.collidable() : !blockState.m_60795_() && !block.m_48673_(blockState) && (blockState.m_60819_().m_76178_() || blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false);
    }

    public static Pattern genShapeForBlock(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        PoseStack transformation = new PoseStack();
        transformation.m_85841_(0.95f, 0.95f, 0.95f);
        transformation.m_252880_(-0.5f, -0.5f, -0.5f);
        try {
            if (blockEntity != null) {
                return Disassembler.getBlockEntity((BlockEntity)blockEntity, (PoseStack)transformation);
            }
            return Disassembler.getBlock((BlockState)blockState, (PoseStack)transformation);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void refreshAll();

    public void loadBlockData(BlockPos var1);

    public void loadFluidData(BlockPos var1);

    public MinecraftSpace getSpace();

    public List<BlockData> getBlockData();

    public List<FluidColumn> getFluidColumns();

    public Optional<BlockData> getBlockData(BlockPos var1);

    public Optional<FluidColumn> getFluidColumn(BlockPos var1);

    public boolean isActive(BlockPos var1);

    public static class FluidColumn {
        private final FluidData top;
        private final FluidData bottom;
        private final Vector3f flow;
        private final float height;
        private long index;

        public FluidColumn(BlockPos start, Level level) {
            this.index = Integer.toUnsignedLong(start.m_123341_()) << 32 | Integer.toUnsignedLong(start.m_123343_());
            BlockPos.MutableBlockPos cursor = new BlockPos((Vec3i)start).m_122032_();
            FluidState fluidState = level.m_6425_((BlockPos)cursor);
            while (!fluidState.m_76178_()) {
                cursor.m_122190_((Vec3i)cursor.m_7495_());
                fluidState = level.m_6425_((BlockPos)cursor);
            }
            cursor.m_122190_((Vec3i)cursor.m_7494_());
            fluidState = level.m_6425_((BlockPos)cursor);
            this.bottom = new FluidData(level, new BlockPos((Vec3i)cursor), level.m_6425_((BlockPos)cursor));
            while (!fluidState.m_76178_()) {
                cursor.m_122190_((Vec3i)cursor.m_7494_());
                fluidState = level.m_6425_((BlockPos)cursor);
            }
            cursor.m_122190_((Vec3i)cursor.m_7495_());
            fluidState = level.m_6425_((BlockPos)cursor);
            this.top = new FluidData(level, new BlockPos((Vec3i)cursor), fluidState);
            this.height = fluidState.m_76155_((BlockGetter)level, (BlockPos)cursor);
            this.flow = Convert.toBullet(fluidState.m_76179_((BlockGetter)level, (BlockPos)cursor));
        }

        public boolean contains(BlockPos blockPos) {
            return this.top.blockPos.m_123341_() == blockPos.m_123341_() && this.top.blockPos.m_123343_() == blockPos.m_123343_() && this.top.blockPos.m_123342_() >= blockPos.m_123342_() && this.bottom.blockPos.m_123342_() <= blockPos.m_123342_();
        }

        public FluidData getTop() {
            return this.top;
        }

        public FluidData getBottom() {
            return this.bottom;
        }

        public float getTopHeight(Vector3f position) {
            return this.height;
        }

        public int getHeight() {
            return this.top.blockPos.m_123342_() - this.bottom.blockPos.m_123342_() + 1;
        }

        public Vector3f getFlow() {
            return this.flow;
        }

        public long getIndex() {
            return this.index;
        }
    }

    public record FluidData(Level level, BlockPos blockPos, FluidState fluidState) {
    }

    public record BlockData(Level level, BlockPos blockPos, BlockState blockState, MinecraftShape shape) {
    }
}

