/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.space;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.api.event.collision.ElementCollisionEvents;
import dev.lazurite.rayon.api.event.collision.PhysicsSpaceEvents;
import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.EntityRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.TerrainRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.space.cache.ChunkCache;
import dev.lazurite.rayon.impl.bullet.collision.space.storage.SpaceStorage;
import dev.lazurite.rayon.impl.bullet.thread.PhysicsThread;
import dev.lazurite.rayon.impl.event.network.EntityNetworking;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class MinecraftSpace
extends PhysicsSpace
implements PhysicsCollisionListener {
    private final CompletableFuture[] futures = new CompletableFuture[3];
    private final Map<BlockPos, TerrainRigidBody> terrainMap;
    private final PhysicsThread thread;
    private final Level level;
    private final ChunkCache chunkCache;
    private volatile boolean stepping;
    private final Set<SectionPos> previousBlockUpdates;

    public static MinecraftSpace get(Level level) {
        return ((SpaceStorage)level).getSpace();
    }

    public static Optional<MinecraftSpace> getOptional(Level level) {
        return Optional.ofNullable(MinecraftSpace.get(level));
    }

    public MinecraftSpace(PhysicsThread thread, Level level) {
        super(PhysicsSpace.BroadphaseType.DBVT);
        this.thread = thread;
        this.level = level;
        this.previousBlockUpdates = new HashSet<SectionPos>();
        this.chunkCache = ChunkCache.create(this);
        this.terrainMap = new ConcurrentHashMap<BlockPos, TerrainRigidBody>();
        this.setGravity(new Vector3f(0.0f, -9.807f, 0.0f));
        this.addCollisionListener(this);
        this.setAccuracy(0.016666668f);
    }

    public void step() {
        MinecraftSpace.get(this.level).getRigidBodiesByClass(ElementRigidBody.class).forEach(ElementRigidBody::updateFrame);
        if (!this.isStepping() && !this.isEmpty()) {
            this.stepping = true;
            block0: for (ElementRigidBody rigidBody : this.getRigidBodiesByClass(ElementRigidBody.class)) {
                if (!rigidBody.terrainLoadingEnabled()) continue;
                for (SectionPos blockPos : this.previousBlockUpdates) {
                    if (!rigidBody.isNear(blockPos)) continue;
                    rigidBody.activate();
                    continue block0;
                }
            }
            this.previousBlockUpdates.clear();
            this.chunkCache.refreshAll();
            for (int i = 0; i < 3; ++i) {
                this.futures[i] = CompletableFuture.runAsync(() -> {
                    this.distributeEvents();
                    PhysicsSpaceEvents.STEP.invoke(new Object[]{this});
                    this.update(0.016666668f);
                }, this.getWorkerThread());
            }
            CompletableFuture.allOf(this.futures).thenRun(() -> {
                this.stepping = false;
            });
        }
    }

    @Override
    public void addCollisionObject(PhysicsCollisionObject collisionObject) {
        if (!collisionObject.isInWorld()) {
            if (collisionObject instanceof ElementRigidBody) {
                ElementRigidBody rigidBody = (ElementRigidBody)collisionObject;
                PhysicsSpaceEvents.ELEMENT_ADDED.invoke(new Object[]{this, rigidBody});
                if (!rigidBody.isInWorld()) {
                    rigidBody.activate();
                    rigidBody.getFrame().set(rigidBody.getPhysicsLocation(new Vector3f()), rigidBody.getPhysicsLocation(new Vector3f()), rigidBody.getPhysicsRotation(new Quaternion()), rigidBody.getPhysicsRotation(new Quaternion()));
                    rigidBody.updateBoundingBox();
                }
                if (this.isServer() && rigidBody instanceof EntityRigidBody) {
                    EntityRigidBody entityRigidBody = (EntityRigidBody)rigidBody;
                    EntityNetworking.sendMovement(entityRigidBody);
                    EntityNetworking.sendProperties(entityRigidBody);
                }
            } else if (collisionObject instanceof TerrainRigidBody) {
                TerrainRigidBody terrain = (TerrainRigidBody)collisionObject;
                this.terrainMap.put(terrain.getBlockPos(), terrain);
            }
            super.addCollisionObject(collisionObject);
        }
    }

    @Override
    public void removeCollisionObject(PhysicsCollisionObject collisionObject) {
        if (collisionObject.isInWorld()) {
            super.removeCollisionObject(collisionObject);
            if (collisionObject instanceof ElementRigidBody) {
                ElementRigidBody rigidBody = (ElementRigidBody)collisionObject;
                PhysicsSpaceEvents.ELEMENT_REMOVED.invoke(new Object[]{this, rigidBody});
            } else if (collisionObject instanceof TerrainRigidBody) {
                TerrainRigidBody terrain = (TerrainRigidBody)collisionObject;
                this.removeTerrainObjectAt(terrain.getBlockPos());
            }
        }
    }

    public boolean isServer() {
        return this.getWorkerThread().getParentExecutor() instanceof MinecraftServer;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public void doBlockUpdate(BlockPos blockPos) {
        this.previousBlockUpdates.add(SectionPos.m_123199_((BlockPos)blockPos));
    }

    public void wakeNearbyElementRigidBodies(BlockPos blockPos) {
        for (ElementRigidBody rigidBody : this.getRigidBodiesByClass(ElementRigidBody.class)) {
            if (!rigidBody.terrainLoadingEnabled() || !rigidBody.isNear(blockPos)) continue;
            rigidBody.activate();
        }
    }

    public Map<BlockPos, TerrainRigidBody> getTerrainMap() {
        return new HashMap<BlockPos, TerrainRigidBody>(this.terrainMap);
    }

    public Optional<TerrainRigidBody> getTerrainObjectAt(BlockPos blockPos) {
        return Optional.ofNullable(this.terrainMap.get(blockPos));
    }

    public void removeTerrainObjectAt(BlockPos blockPos) {
        TerrainRigidBody removed = this.terrainMap.remove(blockPos);
        if (removed != null) {
            this.removeCollisionObject(removed);
        }
    }

    public <T> List<T> getRigidBodiesByClass(Class<T> type) {
        ArrayList<T> out = new ArrayList<T>();
        for (PhysicsRigidBody body : this.getRigidBodyList()) {
            if (!type.isAssignableFrom(body.getClass())) continue;
            out.add(type.cast(body));
        }
        return out;
    }

    public PhysicsThread getWorkerThread() {
        return this.thread;
    }

    public Level getLevel() {
        return this.level;
    }

    public ChunkCache getChunkCache() {
        return this.chunkCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void collision(PhysicsCollisionEvent event) {
        float impulse = event.getAppliedImpulse();
        PhysicsCollisionObject physicsCollisionObject = event.getObjectA();
        if (physicsCollisionObject instanceof ElementRigidBody) {
            ElementRigidBody rigidBodyA = (ElementRigidBody)physicsCollisionObject;
            physicsCollisionObject = event.getObjectB();
            if (physicsCollisionObject instanceof ElementRigidBody) {
                ElementRigidBody rigidBodyB = (ElementRigidBody)physicsCollisionObject;
                ElementCollisionEvents.ELEMENT_COLLISION.invoke(new Object[]{rigidBodyA.getElement(), rigidBodyB.getElement(), Float.valueOf(impulse)});
                return;
            }
        }
        if ((physicsCollisionObject = event.getObjectA()) instanceof TerrainRigidBody) {
            TerrainRigidBody terrain = (TerrainRigidBody)physicsCollisionObject;
            physicsCollisionObject = event.getObjectB();
            if (physicsCollisionObject instanceof ElementRigidBody) {
                ElementRigidBody rigidBody = (ElementRigidBody)physicsCollisionObject;
                ElementCollisionEvents.BLOCK_COLLISION.invoke(new Object[]{rigidBody.getElement(), terrain, Float.valueOf(impulse)});
                return;
            }
        }
        if (!((physicsCollisionObject = event.getObjectA()) instanceof ElementRigidBody)) return;
        ElementRigidBody rigidBody = (ElementRigidBody)physicsCollisionObject;
        physicsCollisionObject = event.getObjectB();
        if (!(physicsCollisionObject instanceof TerrainRigidBody)) return;
        TerrainRigidBody terrain = (TerrainRigidBody)physicsCollisionObject;
        ElementCollisionEvents.BLOCK_COLLISION.invoke(new Object[]{rigidBody.getElement(), terrain, Float.valueOf(impulse)});
    }
}

