/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.body.shape;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.transporter.api.pattern.Pattern;
import dev.lazurite.transporter.impl.pattern.model.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class Triangle {
    private final Vector3f[] vertices;
    private final Vector3f centroid;
    private final Vector3f area;

    public static List<Triangle> getMeshOf(BoundingBox box) {
        float x = box.getXExtent() * 0.5f;
        float y = box.getYExtent() * 0.5f;
        float z = box.getZExtent() * 0.5f;
        ArrayList<Triangle> triangles = new ArrayList<Triangle>(12);
        Triangle.createBoxMesh(x, y, z, Vector3f.ZERO, triangles::add);
        return triangles;
    }

    public static List<Triangle> getMeshOf(VoxelShape voxelShape) {
        if (voxelShape.m_83281_()) {
            return List.of();
        }
        Vector3f vec = new Vector3f();
        List aabbs = voxelShape.m_83299_();
        ArrayList<Triangle> triangles = new ArrayList<Triangle>(12 * aabbs.size());
        for (AABB box : aabbs) {
            double x = box.m_82362_() * 0.5;
            double y = box.m_82376_() * 0.5;
            double z = box.m_82385_() * 0.5;
            Vec3 center = box.m_82399_();
            vec.set((float)center.f_82479_, (float)center.f_82480_, (float)center.f_82481_).subtractLocal(0.5f, 0.5f, 0.5f);
            Triangle.createBoxMesh((float)x, (float)y, (float)z, vec, triangles::add);
        }
        return triangles;
    }

    public static void createBoxMesh(float x, float y, float z, Vector3f offset, Consumer<Triangle> consumer) {
        Vector3f[] points = new Vector3f[]{new Vector3f(x, y, z), new Vector3f(-x, y, z), new Vector3f(0.0f, 0.0f, z), new Vector3f(-x, y, z), new Vector3f(-x, -y, z), new Vector3f(0.0f, 0.0f, z), new Vector3f(-x, -y, z), new Vector3f(x, -y, z), new Vector3f(0.0f, 0.0f, z), new Vector3f(x, -y, z), new Vector3f(x, y, z), new Vector3f(0.0f, 0.0f, z), new Vector3f(-x, y, -z), new Vector3f(x, y, -z), new Vector3f(0.0f, 0.0f, -z), new Vector3f(x, y, -z), new Vector3f(x, -y, -z), new Vector3f(0.0f, 0.0f, -z), new Vector3f(x, -y, -z), new Vector3f(-x, -y, -z), new Vector3f(0.0f, 0.0f, -z), new Vector3f(-x, -y, -z), new Vector3f(-x, y, -z), new Vector3f(0.0f, 0.0f, -z), new Vector3f(x, y, -z), new Vector3f(x, y, z), new Vector3f(x, 0.0f, 0.0f), new Vector3f(x, y, z), new Vector3f(x, -y, z), new Vector3f(x, 0.0f, 0.0f), new Vector3f(x, -y, z), new Vector3f(x, -y, -z), new Vector3f(x, 0.0f, 0.0f), new Vector3f(x, -y, -z), new Vector3f(x, y, -z), new Vector3f(x, 0.0f, 0.0f), new Vector3f(-x, y, z), new Vector3f(-x, y, -z), new Vector3f(-x, 0.0f, 0.0f), new Vector3f(-x, y, -z), new Vector3f(-x, -y, -z), new Vector3f(-x, 0.0f, 0.0f), new Vector3f(-x, -y, -z), new Vector3f(-x, -y, z), new Vector3f(-x, 0.0f, 0.0f), new Vector3f(-x, -y, z), new Vector3f(-x, y, z), new Vector3f(-x, 0.0f, 0.0f), new Vector3f(x, y, -z), new Vector3f(-x, y, -z), new Vector3f(0.0f, y, 0.0f), new Vector3f(-x, y, -z), new Vector3f(-x, y, z), new Vector3f(0.0f, y, 0.0f), new Vector3f(-x, y, z), new Vector3f(x, y, z), new Vector3f(0.0f, y, 0.0f), new Vector3f(x, y, z), new Vector3f(x, y, -z), new Vector3f(0.0f, y, 0.0f), new Vector3f(x, -y, z), new Vector3f(-x, -y, z), new Vector3f(0.0f, -y, 0.0f), new Vector3f(-x, -y, z), new Vector3f(-x, -y, -z), new Vector3f(0.0f, -y, 0.0f), new Vector3f(-x, -y, -z), new Vector3f(x, -y, -z), new Vector3f(0.0f, -y, 0.0f), new Vector3f(x, -y, -z), new Vector3f(x, -y, z), new Vector3f(0.0f, -y, 0.0f)};
        for (int i = 0; i < points.length; i += 3) {
            consumer.accept(new Triangle(points[i].add(offset), points[i + 1].add(offset), points[i + 2].add(offset)));
        }
    }

    public static List<Triangle> getMeshOf(Pattern pattern) {
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        for (Quad quad : pattern.getQuads()) {
            Vector3f centroid = new Vector3f();
            for (Vec3 point : quad.getPoints()) {
                centroid.addLocal(Convert.toBullet(point));
            }
            centroid.divideLocal(4.0f);
            triangles.add(new Triangle(Convert.toBullet((Vec3)quad.getPoints().get(0)), centroid, Convert.toBullet((Vec3)quad.getPoints().get(1))));
            triangles.add(new Triangle(Convert.toBullet((Vec3)quad.getPoints().get(1)), centroid, Convert.toBullet((Vec3)quad.getPoints().get(2))));
            triangles.add(new Triangle(Convert.toBullet((Vec3)quad.getPoints().get(2)), centroid, Convert.toBullet((Vec3)quad.getPoints().get(3))));
            triangles.add(new Triangle(Convert.toBullet((Vec3)quad.getPoints().get(3)), centroid, Convert.toBullet((Vec3)quad.getPoints().get(0))));
        }
        return triangles;
    }

    public Triangle(Vector3f v1, Vector3f v2, Vector3f v3) {
        this.vertices = new Vector3f[]{v1, v2, v3};
        this.centroid = new Vector3f().add(v1).add(v2).add(v3).divideLocal(3.0f);
        Vector3f e1 = v1.subtract(v2);
        Vector3f e2 = v2.subtract(v3);
        this.area = e2.cross(e1).multLocal(0.5f);
        this.area.multLocal(Math.signum(this.centroid.dot(this.area)));
    }

    public Vector3f[] getVertices() {
        return this.vertices;
    }

    public Vector3f getCentroid() {
        return this.centroid;
    }

    public Vector3f getArea() {
        return this.area;
    }

    public Triangle transform(Quaternion quaternion) {
        return new Triangle(Triangle.transform(this.vertices[0].clone(), quaternion), Triangle.transform(this.vertices[1].clone(), quaternion), Triangle.transform(this.vertices[2].clone(), quaternion));
    }

    private static Vector3f transform(Vector3f vector, Quaternion quaternion) {
        return Convert.toBullet(Convert.toMinecraft(vector).mulTransposeDirection((Matrix4fc)Convert.toMinecraft(quaternion).get(new Matrix4f())));
    }
}

