/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.body.shape;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.impl.bullet.collision.body.shape.Triangle;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.transporter.api.pattern.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface MinecraftShape {
    public List<Triangle> getTriangles(Quaternion var1);

    public float getVolume();

    public static Box box(AABB box) {
        return MinecraftShape.box(Convert.toBullet(box));
    }

    public static Box box(BoundingBox box) {
        return new Box(box);
    }

    public static Convex convex(AABB box) {
        return MinecraftShape.convex(Convert.toBullet(box));
    }

    public static Convex convex(VoxelShape voxelShape) {
        return new Convex(Triangle.getMeshOf(voxelShape));
    }

    public static Convex convex(BoundingBox box) {
        return new Convex(Triangle.getMeshOf(box));
    }

    public static Convex convex(Pattern pattern) {
        return new Convex(Triangle.getMeshOf(pattern));
    }

    public static Concave concave(AABB box) {
        return MinecraftShape.concave(Convert.toBullet(box));
    }

    public static Concave concave(BoundingBox box) {
        return new Concave(Triangle.getMeshOf(box));
    }

    public static Concave concave(Pattern pattern) {
        return new Concave(Triangle.getMeshOf(pattern));
    }

    public static final class Box
    extends BoxCollisionShape
    implements MinecraftShape {
        private final List<Triangle> triangles;

        public Box(BoundingBox boundingBox) {
            super(boundingBox.getExtent(new Vector3f()).mult(0.5f));
            this.triangles = new ArrayList<Triangle>(MinecraftShape.convex((BoundingBox)boundingBox).triangles);
        }

        @Override
        public List<Triangle> getTriangles(Quaternion quaternion) {
            return this.triangles;
        }

        @Override
        public float getVolume() {
            return this.toHullShape().aabbVolume();
        }
    }

    public static final class Convex
    extends HullCollisionShape
    implements MinecraftShape {
        private final List<Triangle> triangles;

        public Convex(List<Triangle> triangles) {
            super(triangles.stream().flatMap(triangle -> Stream.of(triangle.getVertices())).toList());
            this.triangles = triangles;
        }

        @Override
        public List<Triangle> getTriangles(Quaternion quaternion) {
            return this.triangles.stream().map(triangle -> triangle.transform(quaternion)).toList();
        }

        @Override
        public float getVolume() {
            return this.aabbVolume();
        }
    }

    public static final class Concave
    extends MeshCollisionShape
    implements MinecraftShape {
        private final List<Triangle> triangles;

        public Concave(List<Triangle> triangles) {
            super(false, ((Supplier<IndexedMesh>)() -> {
                Vector3f[] vertices = (Vector3f[])triangles.stream().flatMap(triangle -> Stream.of(triangle.getVertices())).toArray(Vector3f[]::new);
                int[] indices = new int[vertices.length];
                for (int i = 0; i < vertices.length; ++i) {
                    indices[i] = i;
                }
                return new IndexedMesh(vertices, indices);
            }).get());
            this.triangles = triangles;
        }

        @Override
        public List<Triangle> getTriangles(Quaternion quaternion) {
            return this.triangles.stream().map(triangle -> triangle.transform(quaternion)).toList();
        }

        @Override
        public float getVolume() {
            BoundingBox box = this.boundingBox(new Vector3f(), new Quaternion(), new BoundingBox());
            return box.getXExtent() * box.getYExtent() * box.getZExtent();
        }
    }
}

