/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.impl.bullet.collision.body;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.api.PhysicsElement;
import dev.lazurite.rayon.impl.bullet.collision.body.MinecraftRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.shape.MinecraftShape;
import dev.lazurite.rayon.impl.bullet.collision.space.MinecraftSpace;
import dev.lazurite.rayon.impl.bullet.math.Convert;
import dev.lazurite.rayon.impl.bullet.thread.util.Clock;
import dev.lazurite.rayon.impl.util.Frame;
import dev.lazurite.toolbox.api.math.QuaternionHelper;
import dev.lazurite.toolbox.api.math.VectorHelper;
import java.security.InvalidParameterException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;

public abstract class ElementRigidBody
extends MinecraftRigidBody {
    public static final float SLEEP_TIME_IN_SECONDS = 2.0f;
    protected final PhysicsElement element;
    private final Frame frame;
    private final Clock sleepTimer;
    private boolean terrainLoading;
    private float dragCoefficient;
    private BuoyancyType buoyancyType;
    private DragType dragType;
    private BoundingBox currentBoundingBox = new BoundingBox();
    private AABB currentMinecraftBoundingBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public ElementRigidBody(PhysicsElement element, MinecraftSpace space, MinecraftShape shape, float mass, float dragCoefficient, float friction, float restitution) {
        super(space, shape, mass);
        if (shape instanceof MinecraftShape.Concave) {
            throw new InvalidParameterException("Only massless rigid bodies can use concave shapes.");
        }
        this.element = element;
        this.frame = new Frame();
        this.sleepTimer = new Clock();
        this.setTerrainLoadingEnabled(!this.isStatic());
        this.setDragCoefficient(dragCoefficient);
        this.setFriction(friction);
        this.setRestitution(restitution);
        this.setBuoyancyType(BuoyancyType.WATER);
        this.setDragType(DragType.SIMPLE);
    }

    public PhysicsElement getElement() {
        return this.element;
    }

    public void readTagInfo(CompoundTag tag) {
        if (tag.m_128441_("orientation")) {
            this.setPhysicsRotation(Convert.toBullet(QuaternionHelper.fromTag((CompoundTag)tag.m_128469_("orientation"))));
        }
        if (tag.m_128441_("linearVelocity")) {
            this.setLinearVelocity(Convert.toBullet(VectorHelper.fromTag((CompoundTag)tag.m_128469_("linearVelocity"))));
        }
        if (tag.m_128441_("angularVelocity")) {
            this.setAngularVelocity(Convert.toBullet(VectorHelper.fromTag((CompoundTag)tag.m_128469_("angularVelocity"))));
        }
    }

    public boolean terrainLoadingEnabled() {
        return this.terrainLoading && !this.isStatic();
    }

    public void setTerrainLoadingEnabled(boolean terrainLoading) {
        this.terrainLoading = terrainLoading;
    }

    public float getDragCoefficient() {
        return this.dragCoefficient;
    }

    public void setDragCoefficient(float dragCoefficient) {
        this.dragCoefficient = dragCoefficient;
    }

    public BuoyancyType getBuoyancyType() {
        return this.buoyancyType;
    }

    public void setBuoyancyType(BuoyancyType buoyancyType) {
        this.buoyancyType = buoyancyType;
    }

    public DragType getDragType() {
        return this.dragType;
    }

    public void setDragType(DragType dragType) {
        this.dragType = dragType;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Clock getSleepTimer() {
        return this.sleepTimer;
    }

    @Override
    public Vector3f getOutlineColor() {
        return this.isActive() ? new Vector3f(1.0f, 1.0f, 1.0f) : new Vector3f(1.0f, 0.0f, 0.0f);
    }

    public void updateFrame() {
        this.getFrame().from(this.getFrame(), this.getPhysicsLocation(new Vector3f()), this.getPhysicsRotation(new Quaternion()));
        this.updateBoundingBox();
    }

    public boolean isNear(BlockPos blockPos) {
        return this.currentMinecraftBoundingBox.m_82381_(new AABB(blockPos).m_82400_(0.5));
    }

    public boolean isNear(SectionPos blockPos) {
        return this.currentMinecraftBoundingBox.m_82381_(new AABB(blockPos.m_123250_()).m_82400_(8.5));
    }

    public boolean isWaterBuoyancyEnabled() {
        return this.buoyancyType == BuoyancyType.WATER || this.buoyancyType == BuoyancyType.ALL;
    }

    public boolean isAirBuoyancyEnabled() {
        return this.buoyancyType == BuoyancyType.AIR || this.buoyancyType == BuoyancyType.ALL;
    }

    public boolean isWaterDragEnabled() {
        return this.dragType == DragType.WATER || this.dragType == DragType.ALL || this.dragType == DragType.SIMPLE;
    }

    public boolean isAirDragEnabled() {
        return this.dragType == DragType.AIR || this.dragType == DragType.ALL;
    }

    public void updateBoundingBox() {
        this.currentBoundingBox = this.boundingBox(this.currentBoundingBox);
        this.currentMinecraftBoundingBox = Convert.toMinecraft(this.currentBoundingBox);
    }

    public AABB getCurrentMinecraftBoundingBox() {
        return this.currentMinecraftBoundingBox;
    }

    public BoundingBox getCurrentBoundingBox() {
        return this.currentBoundingBox;
    }

    public static enum BuoyancyType {
        NONE,
        AIR,
        WATER,
        ALL;

    }

    public static enum DragType {
        NONE,
        AIR,
        WATER,
        SIMPLE,
        ALL;

    }
}

