/*
 * Decompiled with CFR 0.152.
 */
package dev.lazurite.rayon.api;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import dev.lazurite.rayon.impl.bullet.collision.body.ElementRigidBody;
import dev.lazurite.rayon.impl.bullet.collision.body.shape.MinecraftShape;
import org.jetbrains.annotations.Nullable;

public interface PhysicsElement<T> {
    @Nullable
    public ElementRigidBody getRigidBody();

    public MinecraftShape.Convex createShape();

    default public Vector3f getPhysicsLocation(Vector3f store, float tickDelta) {
        ElementRigidBody rigidBody = this.getRigidBody();
        if (rigidBody == null) {
            return new Vector3f();
        }
        return rigidBody.getFrame().getLocation(store, tickDelta);
    }

    default public Quaternion getPhysicsRotation(Quaternion store, float tickDelta) {
        ElementRigidBody rigidBody = this.getRigidBody();
        if (rigidBody == null) {
            return new Quaternion();
        }
        return rigidBody.getFrame().getRotation(store, tickDelta);
    }

    default public T cast() {
        return (T)this;
    }
}

