/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.jme3.math.Vector3f;

public class Vec3d
implements Cloneable {
    public static final Vec3d UNIT_X = new Vec3d(1.0, 0.0, 0.0);
    public static final Vec3d UNIT_Y = new Vec3d(0.0, 1.0, 0.0);
    public static final Vec3d UNIT_Z = new Vec3d(0.0, 0.0, 1.0);
    public static final Vec3d ZERO = new Vec3d();
    public double x;
    public double y;
    public double z;

    public Vec3d() {
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(Vec3d v) {
        this(v.x, v.y, v.z);
    }

    public Vec3d(Vector3f v) {
        this(v.x, v.y, v.z);
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x);
        bits ^= Double.doubleToLongBits(this.y) * 31L;
        return (int)(bits ^= Double.doubleToLongBits(this.z) * 31L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Vec3d other = (Vec3d)o;
        if (Double.compare(this.x, other.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, other.y) != 0) {
            return false;
        }
        return Double.compare(this.z, other.z) == 0;
    }

    public boolean isFinite() {
        return !Double.isInfinite(this.x) && !Double.isNaN(this.x) && !Double.isInfinite(this.y) && !Double.isNaN(this.y) && !Double.isInfinite(this.z) && !Double.isNaN(this.z);
    }

    public final Vec3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public final Vec3d set(Vec3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public final Vec3d set(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public final Vec3d clone() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException("Index:" + i);
    }

    public Vec3d set(int i, double d) {
        switch (i) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index:" + i);
            }
        }
        return this;
    }

    public final Vec3d add(Vec3d v) {
        return new Vec3d(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public final Vec3d add(double vx, double vy, double vz) {
        return new Vec3d(this.x + vx, this.y + vy, this.z + vz);
    }

    public final Vec3d subtract(Vec3d v) {
        return new Vec3d(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public final Vec3d addLocal(Vec3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public final Vec3d addLocal(double vx, double vy, double vz) {
        this.x += vx;
        this.y += vy;
        this.z += vz;
        return this;
    }

    public final Vec3d subtractLocal(Vec3d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public final Vec3d multLocal(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    public final Vec3d multLocal(Vec3d v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public final Vec3d divideLocal(Vec3d v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public final double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSq());
    }

    public final Vec3d normalizeLocal() {
        return this.multLocal(1.0 / this.length());
    }

    public final double dot(Vec3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final Vec3d cross(Vec3d v) {
        double xNew = this.y * v.z - this.z * v.y;
        double yNew = this.z * v.x - this.x * v.z;
        double zNew = this.x * v.y - this.y * v.x;
        return new Vec3d(xNew, yNew, zNew);
    }

    public String toString() {
        return "Vec3d[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

