/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

public class Matrix3d
implements Cloneable {
    protected double m00;
    protected double m01;
    protected double m02;
    protected double m10;
    protected double m11;
    protected double m12;
    protected double m20;
    protected double m21;
    protected double m22;

    public Matrix3d() {
        this.makeIdentity();
    }

    public Matrix3d(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3d clone() {
        return new Matrix3d(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public Matrix3d set(Matrix3d mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        return this;
    }

    public Matrix3d makeIdentity() {
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        return this;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    public Matrix3d multLocal(double scale) {
        this.m00 *= scale;
        this.m01 *= scale;
        this.m02 *= scale;
        this.m10 *= scale;
        this.m11 *= scale;
        this.m12 *= scale;
        this.m20 *= scale;
        this.m21 *= scale;
        this.m22 *= scale;
        return this;
    }

    public double determinant() {
        double co00 = this.m11 * this.m22 - this.m12 * this.m21;
        double co10 = this.m12 * this.m20 - this.m10 * this.m22;
        double co20 = this.m10 * this.m21 - this.m11 * this.m20;
        return this.m00 * co00 + this.m01 * co10 + this.m02 * co20;
    }

    public Matrix3d invert() {
        double d = this.determinant();
        if (d == 0.0) {
            return new Matrix3d();
        }
        double rm00 = this.m11 * this.m22 - this.m12 * this.m21;
        double rm01 = this.m02 * this.m21 - this.m01 * this.m22;
        double rm02 = this.m01 * this.m12 - this.m02 * this.m11;
        double rm10 = this.m12 * this.m20 - this.m10 * this.m22;
        double rm11 = this.m00 * this.m22 - this.m02 * this.m20;
        double rm12 = this.m02 * this.m10 - this.m00 * this.m12;
        double rm20 = this.m10 * this.m21 - this.m11 * this.m20;
        double rm21 = this.m01 * this.m20 - this.m00 * this.m21;
        double rm22 = this.m00 * this.m11 - this.m01 * this.m10;
        double s = 1.0 / d;
        return new Matrix3d(rm00 * s, rm01 * s, rm02 * s, rm10 * s, rm11 * s, rm12 * s, rm20 * s, rm21 * s, rm22 * s);
    }

    public Matrix3d transpose() {
        return new Matrix3d(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Matrix3d other = (Matrix3d)o;
        if (Double.compare(this.m00, other.m00) != 0) {
            return false;
        }
        if (Double.compare(this.m01, other.m01) != 0) {
            return false;
        }
        if (Double.compare(this.m02, other.m02) != 0) {
            return false;
        }
        if (Double.compare(this.m10, other.m10) != 0) {
            return false;
        }
        if (Double.compare(this.m11, other.m11) != 0) {
            return false;
        }
        if (Double.compare(this.m12, other.m12) != 0) {
            return false;
        }
        if (Double.compare(this.m20, other.m20) != 0) {
            return false;
        }
        if (Double.compare(this.m21, other.m21) != 0) {
            return false;
        }
        return Double.compare(this.m22, other.m22) == 0;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.m00);
        bits ^= Double.doubleToLongBits(this.m01) * 2L;
        bits ^= Double.doubleToLongBits(this.m02) * 3L;
        bits ^= Double.doubleToLongBits(this.m10) * 4L;
        bits ^= Double.doubleToLongBits(this.m11) * 5L;
        bits ^= Double.doubleToLongBits(this.m12) * 6L;
        bits ^= Double.doubleToLongBits(this.m20) * 7L;
        bits ^= Double.doubleToLongBits(this.m21) * 8L;
        return (int)(bits ^= Double.doubleToLongBits(this.m22) * 9L) ^ (int)(bits >> 32);
    }

    public String toString() {
        return "Matrix3d[{" + this.m00 + ", " + this.m01 + ", " + this.m02 + "}, {" + this.m10 + ", " + this.m11 + ", " + this.m12 + "}, {" + this.m20 + ", " + this.m21 + ", " + this.m22 + "}]";
    }
}

