/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.math.Vector3f;
import com.jme3.util.BufferAllocator;
import com.jme3.util.PrimitiveAllocator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    private static final BufferAllocator allocator = new PrimitiveAllocator();

    private BufferUtils() {
    }

    public static FloatBuffer createFloatBuffer(Vector3f ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(3 * data.length);
        for (Vector3f element : data) {
            if (element != null) {
                buff.put(element.x).put(element.y).put(element.z);
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(float ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(data.length);
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static IntBuffer createIntBuffer(int ... data) {
        if (data == null) {
            return null;
        }
        IntBuffer buff = BufferUtils.createIntBuffer(data.length);
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(int size) {
        FloatBuffer buf = allocator.allocate(4 * size).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buf.clear();
        return buf;
    }

    public static IntBuffer createIntBuffer(int size) {
        IntBuffer buf = allocator.allocate(4 * size).order(ByteOrder.nativeOrder()).asIntBuffer();
        buf.clear();
        return buf;
    }

    public static ByteBuffer createByteBuffer(int size) {
        ByteBuffer buf = allocator.allocate(size).order(ByteOrder.nativeOrder());
        buf.clear();
        return buf;
    }

    public static ShortBuffer createShortBuffer(int size) {
        ShortBuffer buf = allocator.allocate(2 * size).order(ByteOrder.nativeOrder()).asShortBuffer();
        buf.clear();
        return buf;
    }
}

