/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;

public final class NativeLibraryLoader {
    public static final Logger logger = Logger.getLogger(NativeLibraryLoader.class.getName());

    private NativeLibraryLoader() {
    }

    public static boolean loadLibbulletjme(boolean dist, File directory, String buildType, String flavor) {
        File file;
        String name;
        assert (buildType.equals("Debug") || buildType.equals("Release")) : buildType;
        assert (flavor.equals("Sp") || flavor.equals("SpMt") || flavor.equals("SpMtQuickprof") || flavor.equals("SpQuickprof") || flavor.equals("Dp") || flavor.equals("DpMt")) : flavor;
        Platform platform = JmeSystem.getPlatform();
        switch (platform) {
            case Windows32: 
            case Windows64: 
            case Windows_ARM32: 
            case Windows_ARM64: {
                name = "bulletjme.dll";
                break;
            }
            case Android_ARM7: 
            case Android_ARM8: 
            case Linux32: 
            case Linux64: 
            case Linux_ARM32: 
            case Linux_ARM64: {
                name = "libbulletjme.so";
                break;
            }
            case MacOSX32: 
            case MacOSX64: 
            case MacOSX_ARM64: {
                name = "libbulletjme.dylib";
                break;
            }
            default: {
                throw new RuntimeException("platform = " + (Object)((Object)platform));
            }
        }
        if (dist) {
            name = (Object)((Object)platform) + buildType + flavor + "_" + name;
            file = directory;
        } else {
            String subdirectory = MyString.firstToLower(platform.toString());
            file = new File(directory, subdirectory);
            if (!file.exists()) {
                file = directory;
            }
            String bt = MyString.firstToLower(buildType);
            file = new File(file, bt);
            String f = MyString.firstToLower(flavor);
            file = new File(file, f);
        }
        file = new File(file, name);
        String absoluteFilename = file.getAbsolutePath();
        boolean success = false;
        if (!file.exists()) {
            logger.log(Level.SEVERE, "{0} does not exist", absoluteFilename);
        } else if (!file.canRead()) {
            logger.log(Level.SEVERE, "{0} is not readable", absoluteFilename);
        } else {
            logger.log(Level.INFO, "Loading native library from {0}", absoluteFilename);
            System.load(absoluteFilename);
            success = true;
        }
        return success;
    }
}

