/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.Platform;

public class JmeSystem {
    private JmeSystem() {
    }

    private static boolean is64Bit(String arch) {
        if (arch.equals("x86")) {
            return false;
        }
        if (arch.equals("amd64")) {
            return true;
        }
        if (arch.equals("x86_64")) {
            return true;
        }
        if (arch.equals("ppc") || arch.equals("PowerPC")) {
            return false;
        }
        if (arch.equals("ppc64")) {
            return true;
        }
        if (arch.equals("i386") || arch.equals("i686")) {
            return false;
        }
        if (arch.equals("universal")) {
            return false;
        }
        if (arch.equals("aarch32")) {
            return false;
        }
        if (arch.equals("aarch64")) {
            return true;
        }
        if (arch.equals("armv7") || arch.equals("armv7l")) {
            return false;
        }
        if (arch.equals("arm")) {
            return false;
        }
        throw new UnsupportedOperationException("Unsupported architecture: " + arch);
    }

    public static Platform getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean is64 = JmeSystem.is64Bit(arch);
        if (os.contains("windows")) {
            if (arch.startsWith("arm") || arch.startsWith("aarch")) {
                return is64 ? Platform.Windows_ARM64 : Platform.Windows_ARM32;
            }
            return is64 ? Platform.Windows64 : Platform.Windows32;
        }
        if (os.contains("linux") || os.contains("freebsd") || os.contains("sunos") || os.contains("unix")) {
            if (arch.startsWith("arm") || arch.startsWith("aarch")) {
                return is64 ? Platform.Linux_ARM64 : Platform.Linux_ARM32;
            }
            return is64 ? Platform.Linux64 : Platform.Linux32;
        }
        if (os.contains("mac os x") || os.contains("darwin")) {
            if (arch.startsWith("ppc")) {
                return is64 ? Platform.MacOSX_PPC64 : Platform.MacOSX_PPC32;
            }
            if (arch.startsWith("aarch")) {
                return Platform.MacOSX_ARM64;
            }
            return is64 ? Platform.MacOSX64 : Platform.MacOSX32;
        }
        throw new UnsupportedOperationException("The specified platform: " + os + " is not supported.");
    }
}

