/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.util.TempVars;
import java.io.Serializable;
import java.util.logging.Logger;

public final class Quaternion
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Quaternion.class.getName());
    public static final Quaternion IDENTITY = new Quaternion();
    public static final Quaternion DIRECTION_Z = new Quaternion();
    public static final Quaternion ZERO = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    protected float x;
    protected float y;
    protected float z;
    protected float w;

    public Quaternion() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion set(Quaternion q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
        return this;
    }

    public Quaternion(Quaternion q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
    }

    public void loadIdentity() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion fromAngles(float xAngle, float yAngle, float zAngle) {
        float angle = zAngle * 0.5f;
        float sinZ = FastMath.sin(angle);
        float cosZ = FastMath.cos(angle);
        angle = yAngle * 0.5f;
        float sinY = FastMath.sin(angle);
        float cosY = FastMath.cos(angle);
        angle = xAngle * 0.5f;
        float sinX = FastMath.sin(angle);
        float cosX = FastMath.cos(angle);
        float cosYXcosZ = cosY * cosZ;
        float sinYXsinZ = sinY * sinZ;
        float cosYXsinZ = cosY * sinZ;
        float sinYXcosZ = sinY * cosZ;
        this.w = cosYXcosZ * cosX - sinYXsinZ * sinX;
        this.x = cosYXcosZ * sinX + sinYXsinZ * cosX;
        this.y = sinYXcosZ * cosX + cosYXsinZ * sinX;
        this.z = cosYXsinZ * cosX - sinYXcosZ * sinX;
        this.normalizeLocal();
        return this;
    }

    public Quaternion fromRotationMatrix(Matrix3f matrix) {
        return this.fromRotationMatrix(matrix.m00, matrix.m01, matrix.m02, matrix.m10, matrix.m11, matrix.m12, matrix.m20, matrix.m21, matrix.m22);
    }

    public Quaternion fromRotationMatrix(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float t;
        float lengthSquared = m00 * m00 + m10 * m10 + m20 * m20;
        if (lengthSquared != 1.0f && lengthSquared != 0.0f) {
            lengthSquared = 1.0f / FastMath.sqrt(lengthSquared);
            m00 *= lengthSquared;
            m10 *= lengthSquared;
            m20 *= lengthSquared;
        }
        if ((lengthSquared = m01 * m01 + m11 * m11 + m21 * m21) != 1.0f && lengthSquared != 0.0f) {
            lengthSquared = 1.0f / FastMath.sqrt(lengthSquared);
            m01 *= lengthSquared;
            m11 *= lengthSquared;
            m21 *= lengthSquared;
        }
        if ((lengthSquared = m02 * m02 + m12 * m12 + m22 * m22) != 1.0f && lengthSquared != 0.0f) {
            lengthSquared = 1.0f / FastMath.sqrt(lengthSquared);
            m02 *= lengthSquared;
            m12 *= lengthSquared;
            m22 *= lengthSquared;
        }
        if ((t = m00 + m11 + m22) >= 0.0f) {
            float s = FastMath.sqrt(t + 1.0f);
            this.w = 0.5f * s;
            s = 0.5f / s;
            this.x = (m21 - m12) * s;
            this.y = (m02 - m20) * s;
            this.z = (m10 - m01) * s;
        } else if (m00 > m11 && m00 > m22) {
            float s = FastMath.sqrt(1.0f + m00 - m11 - m22);
            this.x = s * 0.5f;
            s = 0.5f / s;
            this.y = (m10 + m01) * s;
            this.z = (m02 + m20) * s;
            this.w = (m21 - m12) * s;
        } else if (m11 > m22) {
            float s = FastMath.sqrt(1.0f + m11 - m00 - m22);
            this.y = s * 0.5f;
            s = 0.5f / s;
            this.x = (m10 + m01) * s;
            this.z = (m21 + m12) * s;
            this.w = (m02 - m20) * s;
        } else {
            float s = FastMath.sqrt(1.0f + m22 - m00 - m11);
            this.z = s * 0.5f;
            s = 0.5f / s;
            this.x = (m02 + m20) * s;
            this.y = (m21 + m12) * s;
            this.w = (m10 - m01) * s;
        }
        return this;
    }

    public Matrix3f toRotationMatrix() {
        Matrix3f matrix = new Matrix3f();
        return this.toRotationMatrix(matrix);
    }

    public Matrix3f toRotationMatrix(Matrix3f result) {
        float norm = this.norm();
        float s = norm == 1.0f ? 2.0f : (norm > 0.0f ? 2.0f / norm : 0.0f);
        float xs = this.x * s;
        float ys = this.y * s;
        float zs = this.z * s;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = this.w * xs;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = this.w * ys;
        float zz = this.z * zs;
        float zw = this.w * zs;
        result.m00 = 1.0f - (yy + zz);
        result.m01 = xy - zw;
        result.m02 = xz + yw;
        result.m10 = xy + zw;
        result.m11 = 1.0f - (xx + zz);
        result.m12 = yz - xw;
        result.m20 = xz - yw;
        result.m21 = yz + xw;
        result.m22 = 1.0f - (xx + yy);
        return result;
    }

    public Matrix4f toTransformMatrix(Matrix4f store) {
        float norm = this.norm();
        float s = norm == 1.0f ? 2.0f : (norm > 0.0f ? 2.0f / norm : 0.0f);
        float xs = this.x * s;
        float ys = this.y * s;
        float zs = this.z * s;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = this.w * xs;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = this.w * ys;
        float zz = this.z * zs;
        float zw = this.w * zs;
        store.m00 = 1.0f - (yy + zz);
        store.m01 = xy - zw;
        store.m02 = xz + yw;
        store.m10 = xy + zw;
        store.m11 = 1.0f - (xx + zz);
        store.m12 = yz - xw;
        store.m20 = xz - yw;
        store.m21 = yz + xw;
        store.m22 = 1.0f - (xx + yy);
        return store;
    }

    public Matrix4f toRotationMatrix(Matrix4f result) {
        TempVars tempv = TempVars.get();
        Vector3f originalScale = tempv.vect1;
        result.toScaleVector(originalScale);
        result.setScale(1.0f, 1.0f, 1.0f);
        float norm = this.norm();
        float s = norm == 1.0f ? 2.0f : (norm > 0.0f ? 2.0f / norm : 0.0f);
        float xs = this.x * s;
        float ys = this.y * s;
        float zs = this.z * s;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = this.w * xs;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = this.w * ys;
        float zz = this.z * zs;
        float zw = this.w * zs;
        result.m00 = 1.0f - (yy + zz);
        result.m01 = xy - zw;
        result.m02 = xz + yw;
        result.m10 = xy + zw;
        result.m11 = 1.0f - (xx + zz);
        result.m12 = yz - xw;
        result.m20 = xz - yw;
        result.m21 = yz + xw;
        result.m22 = 1.0f - (xx + yy);
        result.setScale(originalScale);
        tempv.release();
        return result;
    }

    public Quaternion fromAngleNormalAxis(float angle, Vector3f axis) {
        if (axis.x == 0.0f && axis.y == 0.0f && axis.z == 0.0f) {
            this.loadIdentity();
        } else {
            float halfAngle = 0.5f * angle;
            float sin = FastMath.sin(halfAngle);
            this.w = FastMath.cos(halfAngle);
            this.x = sin * axis.x;
            this.y = sin * axis.y;
            this.z = sin * axis.z;
        }
        return this;
    }

    public Quaternion addLocal(Quaternion q) {
        this.x += q.x;
        this.y += q.y;
        this.z += q.z;
        this.w += q.w;
        return this;
    }

    public Quaternion mult(Quaternion q) {
        return this.mult(q, null);
    }

    public Quaternion mult(Quaternion q, Quaternion storeResult) {
        if (storeResult == null) {
            storeResult = new Quaternion();
        }
        float qw = q.w;
        float qx = q.x;
        float qy = q.y;
        float qz = q.z;
        storeResult.x = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        storeResult.y = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        storeResult.z = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        storeResult.w = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        return storeResult;
    }

    public Quaternion fromAxes(Vector3f xAxis, Vector3f yAxis, Vector3f zAxis) {
        return this.fromRotationMatrix(xAxis.x, yAxis.x, zAxis.x, xAxis.y, yAxis.y, zAxis.y, xAxis.z, yAxis.z, zAxis.z);
    }

    public Vector3f multLocal(Vector3f v) {
        float tempX = this.w * this.w * v.x + 2.0f * this.y * this.w * v.z - 2.0f * this.z * this.w * v.y + this.x * this.x * v.x + 2.0f * this.y * this.x * v.y + 2.0f * this.z * this.x * v.z - this.z * this.z * v.x - this.y * this.y * v.x;
        float tempY = 2.0f * this.x * this.y * v.x + this.y * this.y * v.y + 2.0f * this.z * this.y * v.z + 2.0f * this.w * this.z * v.x - this.z * this.z * v.y + this.w * this.w * v.y - 2.0f * this.x * this.w * v.z - this.x * this.x * v.y;
        v.z = 2.0f * this.x * this.z * v.x + 2.0f * this.y * this.z * v.y + this.z * this.z * v.z - 2.0f * this.w * this.y * v.x - this.y * this.y * v.z + 2.0f * this.w * this.x * v.y - this.x * this.x * v.z + this.w * this.w * v.z;
        v.x = tempX;
        v.y = tempY;
        return v;
    }

    public Quaternion multLocal(Quaternion q) {
        float x1 = this.x * q.w + this.y * q.z - this.z * q.y + this.w * q.x;
        float y1 = -this.x * q.z + this.y * q.w + this.z * q.x + this.w * q.y;
        float z1 = this.x * q.y - this.y * q.x + this.z * q.w + this.w * q.z;
        this.w = -this.x * q.x - this.y * q.y - this.z * q.z + this.w * q.w;
        this.x = x1;
        this.y = y1;
        this.z = z1;
        return this;
    }

    public Quaternion multLocal(float qx, float qy, float qz, float qw) {
        float x1 = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        float y1 = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        float z1 = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        this.w = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        this.x = x1;
        this.y = y1;
        this.z = z1;
        return this;
    }

    public Vector3f mult(Vector3f v, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        if (v.x == 0.0f && v.y == 0.0f && v.z == 0.0f) {
            store.set(0.0f, 0.0f, 0.0f);
        } else {
            float vx = v.x;
            float vy = v.y;
            float vz = v.z;
            store.x = this.w * this.w * vx + 2.0f * this.y * this.w * vz - 2.0f * this.z * this.w * vy + this.x * this.x * vx + 2.0f * this.y * this.x * vy + 2.0f * this.z * this.x * vz - this.z * this.z * vx - this.y * this.y * vx;
            store.y = 2.0f * this.x * this.y * vx + this.y * this.y * vy + 2.0f * this.z * this.y * vz + 2.0f * this.w * this.z * vx - this.z * this.z * vy + this.w * this.w * vy - 2.0f * this.x * this.w * vz - this.x * this.x * vy;
            store.z = 2.0f * this.x * this.z * vx + 2.0f * this.y * this.z * vy + this.z * this.z * vz - 2.0f * this.w * this.y * vx - this.y * this.y * vz + 2.0f * this.w * this.x * vy - this.x * this.x * vz + this.w * this.w * vz;
        }
        return store;
    }

    public Quaternion multLocal(float scalar) {
        this.w *= scalar;
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public float norm() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Quaternion normalizeLocal() {
        float n = 1.0f / FastMath.sqrt(this.norm());
        this.x *= n;
        this.y *= n;
        this.z *= n;
        this.w *= n;
        return this;
    }

    public Quaternion inverse() {
        float norm = this.norm();
        if ((double)norm > 0.0) {
            float invNorm = 1.0f / norm;
            return new Quaternion(-this.x * invNorm, -this.y * invNorm, -this.z * invNorm, this.w * invNorm);
        }
        return null;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Quaternion)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Quaternion comp = (Quaternion)o;
        if (Float.compare(this.x, comp.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, comp.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, comp.z) != 0) {
            return false;
        }
        return Float.compare(this.w, comp.w) == 0;
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + Float.floatToIntBits(this.x);
        hash = 37 * hash + Float.floatToIntBits(this.y);
        hash = 37 * hash + Float.floatToIntBits(this.z);
        hash = 37 * hash + Float.floatToIntBits(this.w);
        return hash;
    }

    public Quaternion clone() {
        try {
            return (Quaternion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    static {
        DIRECTION_Z.fromAxes(Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z);
    }
}

