/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;

public final class Matrix4f
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Matrix4f.class.getName());
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public Matrix4f() {
        this.loadIdentity();
    }

    public void loadIdentity() {
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public void multLocal(float scalar) {
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m02 *= scalar;
        this.m03 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        this.m12 *= scalar;
        this.m13 *= scalar;
        this.m20 *= scalar;
        this.m21 *= scalar;
        this.m22 *= scalar;
        this.m23 *= scalar;
        this.m30 *= scalar;
        this.m31 *= scalar;
        this.m32 *= scalar;
        this.m33 *= scalar;
    }

    public Matrix4f invertLocal() {
        float fA0 = this.m00 * this.m11 - this.m01 * this.m10;
        float fB5 = this.m22 * this.m33 - this.m23 * this.m32;
        float fA1 = this.m00 * this.m12 - this.m02 * this.m10;
        float fB4 = this.m21 * this.m33 - this.m23 * this.m31;
        float fA2 = this.m00 * this.m13 - this.m03 * this.m10;
        float fB3 = this.m21 * this.m32 - this.m22 * this.m31;
        float fA3 = this.m01 * this.m12 - this.m02 * this.m11;
        float fB2 = this.m20 * this.m33 - this.m23 * this.m30;
        float fA4 = this.m01 * this.m13 - this.m03 * this.m11;
        float fB1 = this.m20 * this.m32 - this.m22 * this.m30;
        float fA5 = this.m02 * this.m13 - this.m03 * this.m12;
        float fB0 = this.m20 * this.m31 - this.m21 * this.m30;
        float fDet = fA0 * fB5 - fA1 * fB4 + fA2 * fB3 + fA3 * fB2 - fA4 * fB1 + fA5 * fB0;
        if (FastMath.abs(fDet) <= 0.0f) {
            return this.zero();
        }
        float f00 = this.m11 * fB5 - this.m12 * fB4 + this.m13 * fB3;
        float f10 = -this.m10 * fB5 + this.m12 * fB2 - this.m13 * fB1;
        float f20 = this.m10 * fB4 - this.m11 * fB2 + this.m13 * fB0;
        float f30 = -this.m10 * fB3 + this.m11 * fB1 - this.m12 * fB0;
        float f01 = -this.m01 * fB5 + this.m02 * fB4 - this.m03 * fB3;
        float f11 = this.m00 * fB5 - this.m02 * fB2 + this.m03 * fB1;
        float f21 = -this.m00 * fB4 + this.m01 * fB2 - this.m03 * fB0;
        float f31 = this.m00 * fB3 - this.m01 * fB1 + this.m02 * fB0;
        float f02 = this.m31 * fA5 - this.m32 * fA4 + this.m33 * fA3;
        float f12 = -this.m30 * fA5 + this.m32 * fA2 - this.m33 * fA1;
        float f22 = this.m30 * fA4 - this.m31 * fA2 + this.m33 * fA0;
        float f32 = -this.m30 * fA3 + this.m31 * fA1 - this.m32 * fA0;
        float f03 = -this.m21 * fA5 + this.m22 * fA4 - this.m23 * fA3;
        float f13 = this.m20 * fA5 - this.m22 * fA2 + this.m23 * fA1;
        float f23 = -this.m20 * fA4 + this.m21 * fA2 - this.m23 * fA0;
        float f33 = this.m20 * fA3 - this.m21 * fA1 + this.m22 * fA0;
        this.m00 = f00;
        this.m01 = f01;
        this.m02 = f02;
        this.m03 = f03;
        this.m10 = f10;
        this.m11 = f11;
        this.m12 = f12;
        this.m13 = f13;
        this.m20 = f20;
        this.m21 = f21;
        this.m22 = f22;
        this.m23 = f23;
        this.m30 = f30;
        this.m31 = f31;
        this.m32 = f32;
        this.m33 = f33;
        float fInvDet = 1.0f / fDet;
        this.multLocal(fInvDet);
        return this;
    }

    public Matrix4f zero() {
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m00 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m11 = 0.0f;
        this.m10 = 0.0f;
        this.m23 = 0.0f;
        this.m22 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m33 = 0.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        return this;
    }

    public Vector3f toTranslationVector(Vector3f vector) {
        return vector.set(this.m03, this.m13, this.m23);
    }

    public Quaternion toRotationQuat(Quaternion q) {
        return q.fromRotationMatrix(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public void toRotationMatrix(Matrix3f mat) {
        mat.m00 = this.m00;
        mat.m01 = this.m01;
        mat.m02 = this.m02;
        mat.m10 = this.m10;
        mat.m11 = this.m11;
        mat.m12 = this.m12;
        mat.m20 = this.m20;
        mat.m21 = this.m21;
        mat.m22 = this.m22;
    }

    public Vector3f toScaleVector(Vector3f store) {
        float scaleX = (float)Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
        float scaleY = (float)Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
        float scaleZ = (float)Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
        store.set(scaleX, scaleY, scaleZ);
        return store;
    }

    public void setScale(float x, float y, float z) {
        float length = this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20;
        if (length != 0.0f) {
            length = length == 1.0f ? x : x / FastMath.sqrt(length);
            this.m00 *= length;
            this.m10 *= length;
            this.m20 *= length;
        }
        if ((length = this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21) != 0.0f) {
            length = length == 1.0f ? y : y / FastMath.sqrt(length);
            this.m01 *= length;
            this.m11 *= length;
            this.m21 *= length;
        }
        if ((length = this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) != 0.0f) {
            length = length == 1.0f ? z : z / FastMath.sqrt(length);
            this.m02 *= length;
            this.m12 *= length;
            this.m22 *= length;
        }
    }

    public void setScale(Vector3f scale) {
        this.setScale(scale.x, scale.y, scale.z);
    }

    public void setTranslation(Vector3f translation) {
        this.m03 = translation.x;
        this.m13 = translation.y;
        this.m23 = translation.z;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Matrix4f\n[\n");
        result.append(" ");
        result.append(this.m00);
        result.append("  ");
        result.append(this.m01);
        result.append("  ");
        result.append(this.m02);
        result.append("  ");
        result.append(this.m03);
        result.append(" \n");
        result.append(" ");
        result.append(this.m10);
        result.append("  ");
        result.append(this.m11);
        result.append("  ");
        result.append(this.m12);
        result.append("  ");
        result.append(this.m13);
        result.append(" \n");
        result.append(" ");
        result.append(this.m20);
        result.append("  ");
        result.append(this.m21);
        result.append("  ");
        result.append(this.m22);
        result.append("  ");
        result.append(this.m23);
        result.append(" \n");
        result.append(" ");
        result.append(this.m30);
        result.append("  ");
        result.append(this.m31);
        result.append("  ");
        result.append(this.m32);
        result.append("  ");
        result.append(this.m33);
        result.append(" \n]");
        return result.toString();
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + Float.floatToIntBits(this.m00);
        hash = 37 * hash + Float.floatToIntBits(this.m01);
        hash = 37 * hash + Float.floatToIntBits(this.m02);
        hash = 37 * hash + Float.floatToIntBits(this.m03);
        hash = 37 * hash + Float.floatToIntBits(this.m10);
        hash = 37 * hash + Float.floatToIntBits(this.m11);
        hash = 37 * hash + Float.floatToIntBits(this.m12);
        hash = 37 * hash + Float.floatToIntBits(this.m13);
        hash = 37 * hash + Float.floatToIntBits(this.m20);
        hash = 37 * hash + Float.floatToIntBits(this.m21);
        hash = 37 * hash + Float.floatToIntBits(this.m22);
        hash = 37 * hash + Float.floatToIntBits(this.m23);
        hash = 37 * hash + Float.floatToIntBits(this.m30);
        hash = 37 * hash + Float.floatToIntBits(this.m31);
        hash = 37 * hash + Float.floatToIntBits(this.m32);
        hash = 37 * hash + Float.floatToIntBits(this.m33);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Matrix4f comp = (Matrix4f)o;
        if (Float.compare(this.m00, comp.m00) != 0) {
            return false;
        }
        if (Float.compare(this.m01, comp.m01) != 0) {
            return false;
        }
        if (Float.compare(this.m02, comp.m02) != 0) {
            return false;
        }
        if (Float.compare(this.m03, comp.m03) != 0) {
            return false;
        }
        if (Float.compare(this.m10, comp.m10) != 0) {
            return false;
        }
        if (Float.compare(this.m11, comp.m11) != 0) {
            return false;
        }
        if (Float.compare(this.m12, comp.m12) != 0) {
            return false;
        }
        if (Float.compare(this.m13, comp.m13) != 0) {
            return false;
        }
        if (Float.compare(this.m20, comp.m20) != 0) {
            return false;
        }
        if (Float.compare(this.m21, comp.m21) != 0) {
            return false;
        }
        if (Float.compare(this.m22, comp.m22) != 0) {
            return false;
        }
        if (Float.compare(this.m23, comp.m23) != 0) {
            return false;
        }
        if (Float.compare(this.m30, comp.m30) != 0) {
            return false;
        }
        if (Float.compare(this.m31, comp.m31) != 0) {
            return false;
        }
        if (Float.compare(this.m32, comp.m32) != 0) {
            return false;
        }
        return Float.compare(this.m33, comp.m33) == 0;
    }

    public Matrix4f clone() {
        try {
            return (Matrix4f)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

