/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

class DebugMeshCallback {
    private static final int numAxes = 3;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(DebugMeshCallback.class.getName());
    private final ArrayList<Vector3f> list = new ArrayList(250);

    DebugMeshCallback() {
    }

    FloatBuffer getVertices() {
        int numFloats = 3 * this.list.size();
        FloatBuffer buffer = BufferUtils.createFloatBuffer(numFloats);
        for (Vector3f location : this.list) {
            buffer.put(location.x);
            buffer.put(location.y);
            buffer.put(location.z);
        }
        return buffer;
    }

    float maxDistance(Transform meshToWorld) {
        double maxSquaredDistance = 0.0;
        Vector3f tmpVector = new Vector3f();
        for (Vector3f vertex : this.list) {
            meshToWorld.transformVector(vertex, tmpVector);
            double lengthSquared = MyVector3f.lengthSquared(tmpVector);
            if (!(lengthSquared > maxSquaredDistance)) continue;
            maxSquaredDistance = lengthSquared;
        }
        float result = (float)Math.sqrt(maxSquaredDistance);
        return result;
    }

    float volumeConvex() {
        int numVertices = this.list.size();
        int numTriangles = numVertices / 3;
        assert (numTriangles * 3 == numVertices) : numVertices;
        double total = 0.0;
        if (numTriangles > 0) {
            Vector3f fixed = this.list.get(0);
            for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
                int firstVertex = 3 * triIndex;
                Vector3f pos1 = this.list.get(firstVertex);
                Vector3f pos2 = this.list.get(firstVertex + 1);
                Vector3f pos3 = this.list.get(firstVertex + 2);
                double tetraVolume = MyVolume.tetrahedronVolume(pos1, pos2, pos3, fixed);
                total += tetraVolume;
            }
        }
        float volume = (float)total;
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    private void addVector(float x, float y, float z, int part, int index) {
        this.list.add(new Vector3f(x, y, z));
    }
}

